/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.grpc;

import io.grpc.Attributes;
import io.grpc.CallOptions;
import io.grpc.Deadline;
import io.grpc.Grpc;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.inprocess.InProcessSocketAddress;
import io.opentracing.Span;
import io.opentracing.tag.AbstractTag;
import io.opentracing.tag.Tag;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;

final class GrpcTags {
    static final NullableTag<String> GRPC_AUTHORITY = new NullableTag("grpc.authority");
    static final NullableTag<Attributes> GRPC_CALL_ATTRIBUTES = new NullableTag("grpc.call_attributes");
    static final NullableTag<CallOptions> GRPC_CALL_OPTIONS = new NullableTag("grpc.call_options");
    static final NullableTag<String> GRPC_COMPRESSOR = new NullableTag("grpc.compressor");
    static final Tag<Deadline> GRPC_DEADLINE = new AbstractTag<Deadline>("grpc.deadline_millis"){

        public void set(Span span, Deadline deadline) {
            if (deadline != null) {
                span.setTag(this.key, String.valueOf(deadline.timeRemaining(TimeUnit.MILLISECONDS)));
            }
        }
    };
    static final NullableTag<Metadata> GRPC_HEADERS = new NullableTag("grpc.headers");
    static final Tag<MethodDescriptor> GRPC_METHOD_NAME = new AbstractTag<MethodDescriptor>("grpc.method_name"){

        public void set(Span span, MethodDescriptor method) {
            if (method != null) {
                span.setTag(this.key, method.getFullMethodName());
            }
        }
    };
    static final Tag<MethodDescriptor> GRPC_METHOD_TYPE = new AbstractTag<MethodDescriptor>("grpc.method_type"){

        public void set(Span span, MethodDescriptor method) {
            if (method != null) {
                span.setTag(this.key, method.getType().toString());
            }
        }
    };
    static final Tag<Status> GRPC_STATUS = new AbstractTag<Status>("grpc.status"){

        public void set(Span span, Status status) {
            if (status != null) {
                span.setTag(this.key, status.getCode().name());
            }
        }
    };
    static final Tag<Attributes> PEER_ADDRESS = new AbstractTag<Attributes>("peer.address"){

        public void set(Span span, Attributes attributes) {
            SocketAddress address = (SocketAddress)attributes.get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR);
            if (address instanceof InProcessSocketAddress) {
                span.setTag(this.key, ((InProcessSocketAddress)address).getName());
            } else if (address instanceof InetSocketAddress) {
                InetSocketAddress inetAddress = (InetSocketAddress)address;
                span.setTag(this.key, inetAddress.getHostString() + ':' + inetAddress.getPort());
            }
        }
    };
    static final String COMPONENT_NAME = "java-grpc";

    GrpcTags() {
    }

    static class NullableTag<T>
    extends AbstractTag<T> {
        NullableTag(String tagKey) {
            super(tagKey);
        }

        public void set(Span span, T tagValue) {
            if (tagValue != null) {
                span.setTag(this.key, tagValue.toString());
            }
        }
    }
}

