/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.grpc;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.contrib.grpc.ActiveSpanContextSource;
import io.opentracing.contrib.grpc.ActiveSpanSource;
import io.opentracing.contrib.grpc.ClientCloseDecorator;
import io.opentracing.contrib.grpc.ClientSpanDecorator;
import io.opentracing.contrib.grpc.GrpcFields;
import io.opentracing.contrib.grpc.GrpcTags;
import io.opentracing.contrib.grpc.OperationNameConstructor;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMap;
import io.opentracing.tag.Tags;
import io.opentracing.util.GlobalTracer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;

public class TracingClientInterceptor
implements ClientInterceptor {
    private final Tracer tracer;
    private final OperationNameConstructor operationNameConstructor;
    private final boolean streaming;
    private final boolean verbose;
    private final Set<ClientRequestAttribute> tracedAttributes;
    private final ActiveSpanSource activeSpanSource;
    private final ActiveSpanContextSource activeSpanContextSource;
    private final ImmutableList<ClientSpanDecorator> clientSpanDecorators;
    private final ImmutableList<ClientCloseDecorator> clientCloseDecorators;

    private TracingClientInterceptor(Builder builder) {
        this.tracer = builder.tracer;
        this.operationNameConstructor = builder.operationNameConstructor;
        this.streaming = builder.streaming;
        this.verbose = builder.verbose;
        this.tracedAttributes = builder.tracedAttributes;
        this.activeSpanSource = builder.activeSpanSource;
        this.activeSpanContextSource = builder.activeSpanContextSource;
        this.clientSpanDecorators = ImmutableList.copyOf(builder.clientSpanDecorators.values());
        this.clientCloseDecorators = ImmutableList.copyOf(builder.clientCloseDecorators.values());
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Channel intercept(Channel channel) {
        return ClientInterceptors.intercept((Channel)channel, (ClientInterceptor[])new ClientInterceptor[]{this});
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        String operationName = this.operationNameConstructor.constructOperationName(method);
        SpanContext activeSpanContext = this.getActiveSpanContext();
        final Span span = this.createSpanFromParent(activeSpanContext, operationName);
        try (Scope ignored = this.tracer.scopeManager().activate(span);){
            for (ClientSpanDecorator clientSpanDecorator : this.clientSpanDecorators) {
                clientSpanDecorator.interceptCall(span, method, callOptions);
            }
            for (ClientRequestAttribute attr : this.tracedAttributes) {
                switch (attr) {
                    case ALL_CALL_OPTIONS: {
                        GrpcTags.GRPC_CALL_OPTIONS.set(span, callOptions);
                        break;
                    }
                    case AUTHORITY: {
                        GrpcTags.GRPC_AUTHORITY.set(span, (String)MoreObjects.firstNonNull((Object)callOptions.getAuthority(), (Object)next.authority()));
                        break;
                    }
                    case COMPRESSOR: {
                        GrpcTags.GRPC_COMPRESSOR.set(span, callOptions.getCompressor());
                        break;
                    }
                    case DEADLINE: {
                        GrpcTags.GRPC_DEADLINE.set(span, (Object)callOptions.getDeadline());
                        break;
                    }
                    case METHOD_NAME: {
                        GrpcTags.GRPC_METHOD_NAME.set(span, method);
                        break;
                    }
                    case METHOD_TYPE: {
                        GrpcTags.GRPC_METHOD_TYPE.set(span, method);
                        break;
                    }
                    case HEADERS: {
                        break;
                    }
                }
            }
            Object object = new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){
                private AtomicBoolean finished;
                {
                    super(x0);
                    this.finished = new AtomicBoolean(false);
                }

                public void start(ClientCall.Listener<RespT> responseListener, final Metadata headers) {
                    if (TracingClientInterceptor.this.verbose) {
                        span.log((Map)ImmutableMap.builder().put((Object)"event", (Object)"client-call-start").put((Object)"message", (Object)"Client call started").build());
                    }
                    if (TracingClientInterceptor.this.tracedAttributes.contains((Object)ClientRequestAttribute.HEADERS)) {
                        GrpcTags.GRPC_HEADERS.set(span, headers);
                    }
                    TracingClientInterceptor.this.tracer.inject(span.context(), Format.Builtin.HTTP_HEADERS, (Object)new TextMap(){

                        public void put(String key, String value) {
                            Metadata.Key headerKey = Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
                            headers.put(headerKey, (Object)value);
                        }

                        public Iterator<Map.Entry<String, String>> iterator() {
                            throw new UnsupportedOperationException("TextMapInjectAdapter should only be used with Tracer.inject()");
                        }
                    });
                    ForwardingClientCallListener.SimpleForwardingClientCallListener tracingResponseListener = new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                        public void onHeaders(Metadata headers) {
                            if (TracingClientInterceptor.this.verbose) {
                                span.log((Map)ImmutableMap.builder().put((Object)"event", (Object)"client-call-listener-on-headers").put((Object)"message", (Object)"Client received response headers").put((Object)"headers", (Object)headers.toString()).build());
                            }
                            super.onHeaders(headers);
                        }

                        public void onMessage(RespT message) {
                            if (TracingClientInterceptor.this.streaming || TracingClientInterceptor.this.verbose) {
                                span.log((Map)ImmutableMap.builder().put((Object)"event", (Object)"client-call-listener-on-message").put((Object)"message", (Object)"Client received response message").build());
                            }
                            try (Scope ignored = TracingClientInterceptor.this.tracer.scopeManager().activate(span);){
                                super.onMessage(message);
                            }
                        }

                        public void onClose(Status status, Metadata trailers) {
                            if (!finished.compareAndSet(false, true)) {
                                super.onClose(status, trailers);
                                return;
                            }
                            if (TracingClientInterceptor.this.verbose) {
                                span.log((Map)ImmutableMap.builder().put((Object)"event", (Object)"client-call-listener-on-close").put((Object)"message", (Object)"Client call closed").build());
                                if (!status.isOk()) {
                                    GrpcFields.logClientCallError(span, status.getDescription(), status.getCause());
                                }
                            }
                            GrpcTags.GRPC_STATUS.set(span, (Object)status);
                            for (ClientCloseDecorator clientCloseDecorator : TracingClientInterceptor.this.clientCloseDecorators) {
                                clientCloseDecorator.close(span, status, trailers);
                            }
                            super.onClose(status, trailers);
                            span.finish();
                        }
                    };
                    try (Scope ignored = TracingClientInterceptor.this.tracer.scopeManager().activate(span);){
                        super.start((ClientCall.Listener)tracingResponseListener, headers);
                    }
                }

                public void sendMessage(ReqT message) {
                    if (TracingClientInterceptor.this.streaming || TracingClientInterceptor.this.verbose) {
                        span.log((Map)ImmutableMap.builder().put((Object)"event", (Object)"client-call-send-message").put((Object)"message", (Object)"Client sent message").build());
                    }
                    try (Scope ignored = TracingClientInterceptor.this.tracer.scopeManager().activate(span);){
                        super.sendMessage(message);
                    }
                }

                public void halfClose() {
                    if (TracingClientInterceptor.this.streaming || TracingClientInterceptor.this.verbose) {
                        span.log((Map)ImmutableMap.builder().put((Object)"event", (Object)"client-call-half-close").put((Object)"message", (Object)"Client sent all messages").build());
                    }
                    try (Scope ignored = TracingClientInterceptor.this.tracer.scopeManager().activate(span);){
                        super.halfClose();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void cancel(@Nullable String message, @Nullable Throwable cause) {
                    if (!this.finished.compareAndSet(false, true)) {
                        super.cancel(message, cause);
                        return;
                    }
                    if (TracingClientInterceptor.this.verbose) {
                        span.log((Map)ImmutableMap.builder().put((Object)"event", (Object)"client-call-cancel").put((Object)"message", (Object)"Client call canceled").build());
                        GrpcFields.logClientCallError(span, message, cause);
                    }
                    Status status = cause == null ? Status.UNKNOWN : Status.fromThrowable((Throwable)cause);
                    GrpcTags.GRPC_STATUS.set(span, (Object)status.withDescription(message));
                    try (Scope ignored = TracingClientInterceptor.this.tracer.scopeManager().activate(span);){
                        super.cancel(message, cause);
                    }
                    finally {
                        span.finish();
                    }
                }
            };
            return object;
        }
    }

    private SpanContext getActiveSpanContext() {
        SpanContext spanContext;
        Span activeSpan;
        if (this.activeSpanSource != null && (activeSpan = this.activeSpanSource.getActiveSpan()) != null) {
            return activeSpan.context();
        }
        if (this.activeSpanContextSource != null && (spanContext = this.activeSpanContextSource.getActiveSpanContext()) != null) {
            return spanContext;
        }
        if (this.tracer.activeSpan() != null) {
            return this.tracer.activeSpan().context();
        }
        return null;
    }

    private Span createSpanFromParent(SpanContext parentSpanContext, String operationName) {
        Tracer.SpanBuilder spanBuilder = parentSpanContext == null ? this.tracer.buildSpan(operationName) : this.tracer.buildSpan(operationName).asChildOf(parentSpanContext);
        return spanBuilder.withTag(Tags.SPAN_KIND.getKey(), "client").withTag(Tags.COMPONENT.getKey(), "java-grpc").start();
    }

    public static enum ClientRequestAttribute {
        METHOD_TYPE,
        METHOD_NAME,
        DEADLINE,
        COMPRESSOR,
        AUTHORITY,
        ALL_CALL_OPTIONS,
        HEADERS;

    }

    public static class Builder {
        private Tracer tracer = GlobalTracer.get();
        private OperationNameConstructor operationNameConstructor = OperationNameConstructor.DEFAULT;
        private boolean streaming = false;
        private boolean verbose = false;
        private Set<ClientRequestAttribute> tracedAttributes = new HashSet<ClientRequestAttribute>();
        private ActiveSpanSource activeSpanSource = ActiveSpanSource.NONE;
        private ActiveSpanContextSource activeSpanContextSource = ActiveSpanContextSource.NONE;
        private Map<Class<?>, ClientSpanDecorator> clientSpanDecorators = new HashMap();
        private Map<Class<?>, ClientCloseDecorator> clientCloseDecorators = new HashMap();

        private Builder() {
        }

        public Builder withTracer(Tracer tracer) {
            this.tracer = tracer;
            return this;
        }

        public Builder withOperationName(OperationNameConstructor operationNameConstructor) {
            this.operationNameConstructor = operationNameConstructor;
            return this;
        }

        public Builder withStreaming() {
            this.streaming = true;
            return this;
        }

        public Builder withTracedAttributes(ClientRequestAttribute ... tracedAttributes) {
            this.tracedAttributes = new HashSet<ClientRequestAttribute>(Arrays.asList(tracedAttributes));
            return this;
        }

        public Builder withVerbosity() {
            this.verbose = true;
            return this;
        }

        public Builder withActiveSpanSource(ActiveSpanSource activeSpanSource) {
            this.activeSpanSource = activeSpanSource;
            return this;
        }

        public Builder withActiveSpanContextSource(ActiveSpanContextSource activeSpanContextSource) {
            this.activeSpanContextSource = activeSpanContextSource;
            return this;
        }

        public Builder withClientSpanDecorator(ClientSpanDecorator clientSpanDecorator) {
            this.clientSpanDecorators.put(clientSpanDecorator.getClass(), clientSpanDecorator);
            return this;
        }

        public Builder withClientCloseDecorator(ClientCloseDecorator clientCloseDecorator) {
            this.clientCloseDecorators.put(clientCloseDecorator.getClass(), clientCloseDecorator);
            return this;
        }

        public TracingClientInterceptor build() {
            return new TracingClientInterceptor(this);
        }
    }
}

