/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.grpc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.grpc.BindableService;
import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.ForwardingServerCall;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.ServerServiceDefinition;
import io.grpc.Status;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.contrib.grpc.GrpcFields;
import io.opentracing.contrib.grpc.GrpcTags;
import io.opentracing.contrib.grpc.OpenTracingContextKey;
import io.opentracing.contrib.grpc.OperationNameConstructor;
import io.opentracing.contrib.grpc.ServerCloseDecorator;
import io.opentracing.contrib.grpc.ServerSpanDecorator;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapAdapter;
import io.opentracing.tag.Tag;
import io.opentracing.tag.Tags;
import io.opentracing.util.GlobalTracer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TracingServerInterceptor
implements ServerInterceptor {
    private final Tracer tracer;
    private final OperationNameConstructor operationNameConstructor;
    private final boolean streaming;
    private final boolean verbose;
    private final Set<ServerRequestAttribute> tracedAttributes;
    private final ImmutableList<ServerSpanDecorator> serverSpanDecorators;
    private final ImmutableList<ServerCloseDecorator> serverCloseDecorators;

    private TracingServerInterceptor(Builder builder) {
        this.tracer = builder.tracer;
        this.operationNameConstructor = builder.operationNameConstructor;
        this.streaming = builder.streaming;
        this.verbose = builder.verbose;
        this.tracedAttributes = builder.tracedAttributes;
        this.serverSpanDecorators = ImmutableList.copyOf(builder.serverSpanDecorators.values());
        this.serverCloseDecorators = ImmutableList.copyOf(builder.serverCloseDecorators.values());
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public ServerServiceDefinition intercept(ServerServiceDefinition serviceDef) {
        return ServerInterceptors.intercept((ServerServiceDefinition)serviceDef, (ServerInterceptor[])new ServerInterceptor[]{this});
    }

    public ServerServiceDefinition intercept(BindableService bindableService) {
        return ServerInterceptors.intercept((BindableService)bindableService, (ServerInterceptor[])new ServerInterceptor[]{this});
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        Set headerKeys = headers.keys();
        HashMap<String, String> headerMap = new HashMap<String, String>(headerKeys.size());
        for (String key : headerKeys) {
            if (key.endsWith("-bin")) continue;
            String value = (String)headers.get(Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
            headerMap.put(key, value);
        }
        final Span span = this.getSpanFromHeaders(headerMap, this.operationNameConstructor.constructOperationName(call.getMethodDescriptor()));
        try (Scope ignored = this.tracer.scopeManager().activate(span);){
            for (ServerSpanDecorator serverSpanDecorator : this.serverSpanDecorators) {
                serverSpanDecorator.interceptCall(span, call, headers);
            }
            for (ServerRequestAttribute attr : this.tracedAttributes) {
                switch (attr) {
                    case METHOD_TYPE: {
                        GrpcTags.GRPC_METHOD_TYPE.set(span, (Object)call.getMethodDescriptor());
                        break;
                    }
                    case METHOD_NAME: {
                        GrpcTags.GRPC_METHOD_NAME.set(span, (Object)call.getMethodDescriptor());
                        break;
                    }
                    case CALL_ATTRIBUTES: {
                        GrpcTags.GRPC_CALL_ATTRIBUTES.set(span, call.getAttributes());
                        break;
                    }
                    case HEADERS: {
                        GrpcTags.GRPC_HEADERS.set(span, headers);
                        break;
                    }
                    case PEER_ADDRESS: {
                        GrpcTags.PEER_ADDRESS.set(span, (Object)call.getAttributes());
                    }
                }
            }
            Context ctxWithSpan = Context.current().withValue(OpenTracingContextKey.getKey(), (Object)span).withValue(OpenTracingContextKey.getSpanContextKey(), (Object)span.context());
            ForwardingServerCall.SimpleForwardingServerCall decoratedCall = new ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT>(call){

                public void sendHeaders(Metadata headers) {
                    if (TracingServerInterceptor.this.verbose) {
                        span.log((Map)ImmutableMap.builder().put((Object)"event", (Object)"server-call-send-headers").put((Object)"message", (Object)"Server sent response headers").put((Object)"headers", (Object)headers.toString()).build());
                    }
                    super.sendHeaders(headers);
                }

                public void sendMessage(RespT message) {
                    if (TracingServerInterceptor.this.streaming || TracingServerInterceptor.this.verbose) {
                        span.log((Map)ImmutableMap.builder().put((Object)"event", (Object)"server-call-send-message").put((Object)"message", (Object)"Server sent response message").build());
                    }
                    try (Scope ignored = TracingServerInterceptor.this.tracer.scopeManager().activate(span);){
                        super.sendMessage(message);
                    }
                }

                public void close(Status status, Metadata trailers) {
                    if (TracingServerInterceptor.this.verbose) {
                        span.log((Map)ImmutableMap.builder().put((Object)"event", (Object)"server-call-close").put((Object)"message", (Object)"Server call closed").build());
                        if (!status.isOk()) {
                            GrpcFields.logServerCallError(span, status.getDescription(), status.getCause());
                        }
                    }
                    GrpcTags.GRPC_STATUS.set(span, (Object)status);
                    for (ServerCloseDecorator serverCloseDecorator : TracingServerInterceptor.this.serverCloseDecorators) {
                        serverCloseDecorator.close(span, status, trailers);
                    }
                    super.close(status, trailers);
                }
            };
            ServerCall.Listener listenerWithContext = Contexts.interceptCall((Context)ctxWithSpan, (ServerCall)decoratedCall, (Metadata)headers, next);
            ForwardingServerCallListener.SimpleForwardingServerCallListener simpleForwardingServerCallListener = new ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT>(listenerWithContext){

                public void onReady() {
                    try (Scope ignored = TracingServerInterceptor.this.tracer.scopeManager().activate(span);){
                        super.onReady();
                    }
                }

                public void onMessage(ReqT message) {
                    if (TracingServerInterceptor.this.streaming || TracingServerInterceptor.this.verbose) {
                        span.log((Map)ImmutableMap.builder().put((Object)"event", (Object)"server-call-listener-on-message").put((Object)"message", (Object)"Server received message").build());
                    }
                    try (Scope ignored = TracingServerInterceptor.this.tracer.scopeManager().activate(span);){
                        super.onMessage(message);
                    }
                }

                public void onHalfClose() {
                    if (TracingServerInterceptor.this.streaming || TracingServerInterceptor.this.verbose) {
                        span.log((Map)ImmutableMap.builder().put((Object)"event", (Object)"server-call-listener-on-half-close").put((Object)"message", (Object)"Server received all messages").build());
                    }
                    try (Scope ignored = TracingServerInterceptor.this.tracer.scopeManager().activate(span);){
                        super.onHalfClose();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onCancel() {
                    if (TracingServerInterceptor.this.verbose) {
                        span.log((Map)ImmutableMap.builder().put((Object)"event", (Object)"server-call-listener-on-cancel").put((Object)"message", (Object)"Server call cancelled").build());
                    }
                    GrpcTags.GRPC_STATUS.set(span, (Object)Status.CANCELLED);
                    try (Scope ignored = TracingServerInterceptor.this.tracer.scopeManager().activate(span);){
                        super.onCancel();
                    }
                    finally {
                        span.finish();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onComplete() {
                    if (TracingServerInterceptor.this.verbose) {
                        span.log((Map)ImmutableMap.builder().put((Object)"event", (Object)"server-call-listener-on-complete").put((Object)"message", (Object)"Server call completed").build());
                    }
                    try (Scope ignored = TracingServerInterceptor.this.tracer.scopeManager().activate(span);){
                        super.onComplete();
                    }
                    finally {
                        span.finish();
                    }
                }
            };
            return simpleForwardingServerCallListener;
        }
    }

    @VisibleForTesting
    Span getSpanFromHeaders(Map<String, String> headers, String operationName) {
        ImmutableMap fields = null;
        Tracer.SpanBuilder spanBuilder = this.tracer.buildSpan(operationName);
        try {
            SpanContext parentSpanCtx = this.tracer.extract(Format.Builtin.HTTP_HEADERS, (Object)new TextMapAdapter(headers));
            if (parentSpanCtx != null) {
                spanBuilder = spanBuilder.asChildOf(parentSpanCtx);
            }
        }
        catch (IllegalArgumentException iae) {
            spanBuilder = spanBuilder.withTag((Tag)Tags.ERROR, (Object)Boolean.TRUE);
            fields = ImmutableMap.builder().put((Object)"event", (Object)"error").put((Object)"error.object", (Object)new RuntimeException("Parent span context extract failed", iae)).build();
        }
        Span span = spanBuilder.withTag(Tags.SPAN_KIND.getKey(), "server").withTag(Tags.COMPONENT.getKey(), "java-grpc").start();
        if (fields != null) {
            span.log((Map)fields);
        }
        return span;
    }

    public static enum ServerRequestAttribute {
        HEADERS,
        METHOD_TYPE,
        METHOD_NAME,
        CALL_ATTRIBUTES,
        PEER_ADDRESS;

    }

    public static class Builder {
        private Tracer tracer = GlobalTracer.get();
        private OperationNameConstructor operationNameConstructor = OperationNameConstructor.DEFAULT;
        private boolean streaming = false;
        private boolean verbose = false;
        private Set<ServerRequestAttribute> tracedAttributes = new HashSet<ServerRequestAttribute>();
        private Map<Class<?>, ServerSpanDecorator> serverSpanDecorators = new HashMap();
        private Map<Class<?>, ServerCloseDecorator> serverCloseDecorators = new HashMap();

        private Builder() {
        }

        public Builder withTracer(Tracer tracer) {
            this.tracer = tracer;
            return this;
        }

        public Builder withOperationName(OperationNameConstructor operationNameConstructor) {
            this.operationNameConstructor = operationNameConstructor;
            return this;
        }

        public Builder withTracedAttributes(ServerRequestAttribute ... attributes) {
            this.tracedAttributes = new HashSet<ServerRequestAttribute>(Arrays.asList(attributes));
            return this;
        }

        public Builder withStreaming() {
            this.streaming = true;
            return this;
        }

        public Builder withVerbosity() {
            this.verbose = true;
            return this;
        }

        public Builder withServerSpanDecorator(ServerSpanDecorator serverSpanDecorator) {
            this.serverSpanDecorators.put(serverSpanDecorator.getClass(), serverSpanDecorator);
            return this;
        }

        public Builder withServerCloseDecorator(ServerCloseDecorator serverCloseDecorator) {
            this.serverCloseDecorators.put(serverCloseDecorator.getClass(), serverCloseDecorator);
            return this;
        }

        public TracingServerInterceptor build() {
            return new TracingServerInterceptor(this);
        }
    }
}

