/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.hazelcast;

import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.IFunction;
import io.opentracing.Span;
import io.opentracing.contrib.hazelcast.TracingCompletableFuture;
import io.opentracing.contrib.hazelcast.TracingFunction;
import io.opentracing.contrib.hazelcast.TracingHelper;
import java.util.Map;

public class TracingAtomicLong
implements IAtomicLong {
    private final IAtomicLong atomicLong;
    private final TracingHelper helper;
    private final boolean traceWithActiveSpanOnly;

    public TracingAtomicLong(IAtomicLong atomicLong, boolean traceWithActiveSpanOnly) {
        this.atomicLong = atomicLong;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.helper = new TracingHelper(traceWithActiveSpanOnly);
    }

    public String getName() {
        return this.atomicLong.getName();
    }

    public long addAndGet(long delta) {
        Span span = this.helper.buildSpan("addAndGet", (DistributedObject)this.atomicLong);
        span.setTag("delta", (Number)delta);
        return TracingHelper.decorate(() -> this.atomicLong.addAndGet(delta), span);
    }

    public boolean compareAndSet(long expect, long update) {
        Span span = this.helper.buildSpan("compareAndSet", (DistributedObject)this.atomicLong);
        span.setTag("expect", (Number)expect);
        span.setTag("update", (Number)update);
        return TracingHelper.decorate(() -> this.atomicLong.compareAndSet(expect, update), span);
    }

    public long decrementAndGet() {
        Span span = this.helper.buildSpan("decrementAndGet", (DistributedObject)this.atomicLong);
        return TracingHelper.decorate(() -> ((IAtomicLong)this.atomicLong).decrementAndGet(), span);
    }

    public long get() {
        Span span = this.helper.buildSpan("get", (DistributedObject)this.atomicLong);
        return TracingHelper.decorate(() -> ((IAtomicLong)this.atomicLong).get(), span);
    }

    public long getAndAdd(long delta) {
        Span span = this.helper.buildSpan("getAndAdd", (DistributedObject)this.atomicLong);
        span.setTag("delta", (Number)delta);
        return TracingHelper.decorate(() -> this.atomicLong.getAndAdd(delta), span);
    }

    public long getAndSet(long newValue) {
        Span span = this.helper.buildSpan("getAndSet", (DistributedObject)this.atomicLong);
        span.setTag("newValue", (Number)newValue);
        return TracingHelper.decorate(() -> this.atomicLong.getAndSet(newValue), span);
    }

    public long incrementAndGet() {
        Span span = this.helper.buildSpan("incrementAndGet", (DistributedObject)this.atomicLong);
        return TracingHelper.decorate(() -> ((IAtomicLong)this.atomicLong).incrementAndGet(), span);
    }

    public long getAndIncrement() {
        Span span = this.helper.buildSpan("getAndIncrement", (DistributedObject)this.atomicLong);
        return TracingHelper.decorate(() -> ((IAtomicLong)this.atomicLong).getAndIncrement(), span);
    }

    public void set(long newValue) {
        Span span = this.helper.buildSpan("set", (DistributedObject)this.atomicLong);
        span.setTag("newValue", (Number)newValue);
        TracingHelper.decorateAction(() -> this.atomicLong.set(newValue), span);
    }

    public void alter(IFunction<Long, Long> function) {
        Span span = this.helper.buildSpan("alter", (DistributedObject)this.atomicLong);
        span.setTag("function", TracingHelper.nullableClass(function));
        Map<String, String> spanContextMap = TracingHelper.inject(span);
        TracingHelper.decorateAction(() -> this.atomicLong.alter(new TracingFunction(function, this.traceWithActiveSpanOnly, spanContextMap)), span);
    }

    public long alterAndGet(IFunction<Long, Long> function) {
        Span span = this.helper.buildSpan("alterAndGet", (DistributedObject)this.atomicLong);
        span.setTag("function", TracingHelper.nullableClass(function));
        Map<String, String> spanContextMap = TracingHelper.inject(span);
        return TracingHelper.decorate(() -> this.atomicLong.alterAndGet(new TracingFunction(function, this.traceWithActiveSpanOnly, spanContextMap)), span);
    }

    public long getAndAlter(IFunction<Long, Long> function) {
        Span span = this.helper.buildSpan("getAndAlter", (DistributedObject)this.atomicLong);
        span.setTag("function", TracingHelper.nullableClass(function));
        Map<String, String> spanContextMap = TracingHelper.inject(span);
        return TracingHelper.decorate(() -> this.atomicLong.getAndAlter(new TracingFunction(function, this.traceWithActiveSpanOnly, spanContextMap)), span);
    }

    public <R> R apply(IFunction<Long, R> function) {
        Span span = this.helper.buildSpan("apply", (DistributedObject)this.atomicLong);
        span.setTag("function", TracingHelper.nullableClass(function));
        Map<String, String> spanContextMap = TracingHelper.inject(span);
        return (R)TracingHelper.decorate(() -> this.atomicLong.apply(new TracingFunction(function, this.traceWithActiveSpanOnly, spanContextMap)), span);
    }

    public ICompletableFuture<Long> addAndGetAsync(long delta) {
        Span span = this.helper.buildSpan("addAndGetAsync", (DistributedObject)this.atomicLong);
        span.setTag("delta", (Number)delta);
        return TracingHelper.decorate(() -> new TracingCompletableFuture(this.atomicLong.addAndGetAsync(delta), this.traceWithActiveSpanOnly, TracingHelper.inject(span)), span);
    }

    public ICompletableFuture<Boolean> compareAndSetAsync(long expect, long update) {
        Span span = this.helper.buildSpan("compareAndSetAsync", (DistributedObject)this.atomicLong);
        span.setTag("expect", (Number)expect);
        span.setTag("update", (Number)update);
        return TracingHelper.decorate(() -> new TracingCompletableFuture(this.atomicLong.compareAndSetAsync(expect, update), this.traceWithActiveSpanOnly, TracingHelper.inject(span)), span);
    }

    public ICompletableFuture<Long> decrementAndGetAsync() {
        Span span = this.helper.buildSpan("decrementAndGetAsync", (DistributedObject)this.atomicLong);
        return TracingHelper.decorate(() -> new TracingCompletableFuture(this.atomicLong.decrementAndGetAsync(), this.traceWithActiveSpanOnly, TracingHelper.inject(span)), span);
    }

    public ICompletableFuture<Long> getAsync() {
        Span span = this.helper.buildSpan("getAsync", (DistributedObject)this.atomicLong);
        return TracingHelper.decorate(() -> new TracingCompletableFuture(this.atomicLong.getAsync(), this.traceWithActiveSpanOnly, TracingHelper.inject(span)), span);
    }

    public ICompletableFuture<Long> getAndAddAsync(long delta) {
        Span span = this.helper.buildSpan("getAndAddAsync", (DistributedObject)this.atomicLong);
        span.setTag("delta", (Number)delta);
        return TracingHelper.decorate(() -> new TracingCompletableFuture(this.atomicLong.getAndAddAsync(delta), this.traceWithActiveSpanOnly, TracingHelper.inject(span)), span);
    }

    public ICompletableFuture<Long> getAndSetAsync(long newValue) {
        Span span = this.helper.buildSpan("getAndSetAsync", (DistributedObject)this.atomicLong);
        span.setTag("newValue", (Number)newValue);
        return TracingHelper.decorate(() -> new TracingCompletableFuture(this.atomicLong.getAndSetAsync(newValue), this.traceWithActiveSpanOnly, TracingHelper.inject(span)), span);
    }

    public ICompletableFuture<Long> incrementAndGetAsync() {
        Span span = this.helper.buildSpan("incrementAndGetAsync", (DistributedObject)this.atomicLong);
        return TracingHelper.decorate(() -> new TracingCompletableFuture(this.atomicLong.incrementAndGetAsync(), this.traceWithActiveSpanOnly, TracingHelper.inject(span)), span);
    }

    public ICompletableFuture<Long> getAndIncrementAsync() {
        Span span = this.helper.buildSpan("getAndIncrementAsync", (DistributedObject)this.atomicLong);
        return TracingHelper.decorate(() -> new TracingCompletableFuture(this.atomicLong.getAndIncrementAsync(), this.traceWithActiveSpanOnly, TracingHelper.inject(span)), span);
    }

    public ICompletableFuture<Void> setAsync(long newValue) {
        Span span = this.helper.buildSpan("setAsync", (DistributedObject)this.atomicLong);
        span.setTag("newValue", (Number)newValue);
        return TracingHelper.decorate(() -> new TracingCompletableFuture(this.atomicLong.setAsync(newValue), this.traceWithActiveSpanOnly, TracingHelper.inject(span)), span);
    }

    public ICompletableFuture<Void> alterAsync(IFunction<Long, Long> function) {
        Span span = this.helper.buildSpan("alterAsync", (DistributedObject)this.atomicLong);
        span.setTag("function", TracingHelper.nullableClass(function));
        Map<String, String> spanContextMap = TracingHelper.inject(span);
        ICompletableFuture future = this.atomicLong.alterAsync(new TracingFunction<Long, Long>(function, this.traceWithActiveSpanOnly, spanContextMap));
        return TracingHelper.decorate(() -> new TracingCompletableFuture(future, this.traceWithActiveSpanOnly, TracingHelper.inject(span)), span);
    }

    public ICompletableFuture<Long> alterAndGetAsync(IFunction<Long, Long> function) {
        Span span = this.helper.buildSpan("alterAndGetAsync", (DistributedObject)this.atomicLong);
        span.setTag("function", TracingHelper.nullableClass(function));
        Map<String, String> spanContextMap = TracingHelper.inject(span);
        ICompletableFuture future = this.atomicLong.alterAndGetAsync(new TracingFunction<Long, Long>(function, this.traceWithActiveSpanOnly, spanContextMap));
        return TracingHelper.decorate(() -> new TracingCompletableFuture(future, this.traceWithActiveSpanOnly, TracingHelper.inject(span)), span);
    }

    public ICompletableFuture<Long> getAndAlterAsync(IFunction<Long, Long> function) {
        Span span = this.helper.buildSpan("getAndAlterAsync", (DistributedObject)this.atomicLong);
        span.setTag("function", TracingHelper.nullableClass(function));
        Map<String, String> spanContextMap = TracingHelper.inject(span);
        ICompletableFuture future = this.atomicLong.getAndAlterAsync(new TracingFunction<Long, Long>(function, this.traceWithActiveSpanOnly, spanContextMap));
        return TracingHelper.decorate(() -> new TracingCompletableFuture(future, this.traceWithActiveSpanOnly, TracingHelper.inject(span)), span);
    }

    public <R> ICompletableFuture<R> applyAsync(IFunction<Long, R> function) {
        Span span = this.helper.buildSpan("applyAsync", (DistributedObject)this.atomicLong);
        span.setTag("function", TracingHelper.nullableClass(function));
        Map<String, String> spanContextMap = TracingHelper.inject(span);
        ICompletableFuture future = this.atomicLong.applyAsync(new TracingFunction<Long, R>(function, this.traceWithActiveSpanOnly, spanContextMap));
        return TracingHelper.decorate(() -> new TracingCompletableFuture(future, this.traceWithActiveSpanOnly, TracingHelper.inject(span)), span);
    }

    public String getPartitionKey() {
        return this.atomicLong.getPartitionKey();
    }

    public String getServiceName() {
        return this.atomicLong.getServiceName();
    }

    public void destroy() {
        Span span = this.helper.buildSpan("destroy", (DistributedObject)this.atomicLong);
        TracingHelper.decorateAction(() -> ((IAtomicLong)this.atomicLong).destroy(), span);
    }
}

