/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.hazelcast;

import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.IAtomicReference;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.IFunction;
import io.opentracing.Span;
import io.opentracing.contrib.hazelcast.TracingCompletableFuture;
import io.opentracing.contrib.hazelcast.TracingFunction;
import io.opentracing.contrib.hazelcast.TracingHelper;
import java.util.Map;

public class TracingAtomicReference<E>
implements IAtomicReference<E> {
    private final IAtomicReference<E> reference;
    private final TracingHelper helper;
    private final boolean traceWithActiveSpanOnly;

    public TracingAtomicReference(IAtomicReference<E> reference, boolean traceWithActiveSpanOnly) {
        this.reference = reference;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.helper = new TracingHelper(traceWithActiveSpanOnly);
    }

    public boolean compareAndSet(E expect, E update) {
        Span span = this.helper.buildSpan("compareAndSet", (DistributedObject)this.reference);
        span.setTag("expect", TracingHelper.nullable(expect));
        span.setTag("update", TracingHelper.nullable(update));
        return TracingHelper.decorate(() -> this.reference.compareAndSet(expect, update), span);
    }

    public E get() {
        Span span = this.helper.buildSpan("get", (DistributedObject)this.reference);
        return (E)TracingHelper.decorate(() -> this.reference.get(), span);
    }

    public void set(E newValue) {
        Span span = this.helper.buildSpan("set", (DistributedObject)this.reference);
        span.setTag("newValue", TracingHelper.nullable(newValue));
        TracingHelper.decorateAction(() -> this.reference.set(newValue), span);
    }

    public E getAndSet(E newValue) {
        Span span = this.helper.buildSpan("getAndSet", (DistributedObject)this.reference);
        span.setTag("newValue", TracingHelper.nullable(newValue));
        return (E)TracingHelper.decorate(() -> this.reference.getAndSet(newValue), span);
    }

    public E setAndGet(E update) {
        Span span = this.helper.buildSpan("setAndGet", (DistributedObject)this.reference);
        span.setTag("update", TracingHelper.nullable(update));
        return (E)TracingHelper.decorate(() -> this.reference.setAndGet(update), span);
    }

    public boolean isNull() {
        Span span = this.helper.buildSpan("isNull", (DistributedObject)this.reference);
        return TracingHelper.decorate(() -> this.reference.isNull(), span);
    }

    public void clear() {
        Span span = this.helper.buildSpan("clear", (DistributedObject)this.reference);
        TracingHelper.decorateAction(() -> this.reference.clear(), span);
    }

    public boolean contains(E value) {
        Span span = this.helper.buildSpan("contains", (DistributedObject)this.reference);
        span.setTag("value", TracingHelper.nullable(value));
        return TracingHelper.decorate(() -> this.reference.contains(value), span);
    }

    public void alter(IFunction<E, E> function) {
        Span span = this.helper.buildSpan("alter", (DistributedObject)this.reference);
        span.setTag("function", TracingHelper.nullableClass(function));
        TracingHelper.decorateAction(() -> this.reference.alter(new TracingFunction(function, this.traceWithActiveSpanOnly, TracingHelper.inject(span))), span);
    }

    public E alterAndGet(IFunction<E, E> function) {
        Span span = this.helper.buildSpan("alterAndGet", (DistributedObject)this.reference);
        span.setTag("function", TracingHelper.nullableClass(function));
        return (E)TracingHelper.decorate(() -> this.reference.alterAndGet(new TracingFunction(function, this.traceWithActiveSpanOnly, TracingHelper.inject(span))), span);
    }

    public E getAndAlter(IFunction<E, E> function) {
        Span span = this.helper.buildSpan("getAndAlter", (DistributedObject)this.reference);
        span.setTag("function", TracingHelper.nullableClass(function));
        return (E)TracingHelper.decorate(() -> this.reference.getAndAlter(new TracingFunction(function, this.traceWithActiveSpanOnly, TracingHelper.inject(span))), span);
    }

    public <R> R apply(IFunction<E, R> function) {
        Span span = this.helper.buildSpan("apply", (DistributedObject)this.reference);
        span.setTag("function", TracingHelper.nullableClass(function));
        return (R)TracingHelper.decorate(() -> this.reference.apply(new TracingFunction(function, this.traceWithActiveSpanOnly, TracingHelper.inject(span))), span);
    }

    public ICompletableFuture<Boolean> compareAndSetAsync(E expect, E update) {
        Span span = this.helper.buildSpan("compareAndSetAsync", (DistributedObject)this.reference);
        span.setTag("expect", TracingHelper.nullable(expect));
        span.setTag("update", TracingHelper.nullable(update));
        return TracingHelper.decorate(() -> new TracingCompletableFuture(this.reference.compareAndSetAsync(expect, update), this.traceWithActiveSpanOnly, TracingHelper.inject(span)), span);
    }

    public ICompletableFuture<E> getAsync() {
        Span span = this.helper.buildSpan("getAsync", (DistributedObject)this.reference);
        return TracingHelper.decorate(() -> new TracingCompletableFuture(this.reference.getAsync(), this.traceWithActiveSpanOnly, TracingHelper.inject(span)), span);
    }

    public ICompletableFuture<Void> setAsync(E newValue) {
        Span span = this.helper.buildSpan("setAsync", (DistributedObject)this.reference);
        span.setTag("newValue", TracingHelper.nullable(newValue));
        return TracingHelper.decorate(() -> new TracingCompletableFuture(this.reference.setAsync(newValue), this.traceWithActiveSpanOnly, TracingHelper.inject(span)), span);
    }

    public ICompletableFuture<E> getAndSetAsync(E newValue) {
        Span span = this.helper.buildSpan("getAndSetAsync", (DistributedObject)this.reference);
        span.setTag("newValue", TracingHelper.nullable(newValue));
        return TracingHelper.decorate(() -> new TracingCompletableFuture(this.reference.getAndSetAsync(newValue), this.traceWithActiveSpanOnly, TracingHelper.inject(span)), span);
    }

    public ICompletableFuture<Boolean> isNullAsync() {
        Span span = this.helper.buildSpan("isNullAsync", (DistributedObject)this.reference);
        return TracingHelper.decorate(() -> new TracingCompletableFuture(this.reference.isNullAsync(), this.traceWithActiveSpanOnly, TracingHelper.inject(span)), span);
    }

    public ICompletableFuture<Void> clearAsync() {
        Span span = this.helper.buildSpan("clearAsync", (DistributedObject)this.reference);
        return TracingHelper.decorate(() -> new TracingCompletableFuture(this.reference.clearAsync(), this.traceWithActiveSpanOnly, TracingHelper.inject(span)), span);
    }

    public ICompletableFuture<Boolean> containsAsync(E expected) {
        Span span = this.helper.buildSpan("containsAsync", (DistributedObject)this.reference);
        span.setTag("expected", TracingHelper.nullable(expected));
        return TracingHelper.decorate(() -> new TracingCompletableFuture(this.reference.containsAsync(expected), this.traceWithActiveSpanOnly, TracingHelper.inject(span)), span);
    }

    public ICompletableFuture<Void> alterAsync(IFunction<E, E> function) {
        Span span = this.helper.buildSpan("alterAsync", (DistributedObject)this.reference);
        span.setTag("function", TracingHelper.nullableClass(function));
        Map<String, String> spanContextMap = TracingHelper.inject(span);
        ICompletableFuture future = this.reference.alterAsync(new TracingFunction<E, E>(function, this.traceWithActiveSpanOnly, spanContextMap));
        return TracingHelper.decorate(() -> new TracingCompletableFuture(future, this.traceWithActiveSpanOnly, TracingHelper.inject(span)), span);
    }

    public ICompletableFuture<E> alterAndGetAsync(IFunction<E, E> function) {
        Span span = this.helper.buildSpan("alterAndGetAsync", (DistributedObject)this.reference);
        span.setTag("function", TracingHelper.nullableClass(function));
        Map<String, String> spanContextMap = TracingHelper.inject(span);
        ICompletableFuture future = this.reference.alterAndGetAsync(new TracingFunction<E, E>(function, this.traceWithActiveSpanOnly, spanContextMap));
        return TracingHelper.decorate(() -> new TracingCompletableFuture(future, this.traceWithActiveSpanOnly, TracingHelper.inject(span)), span);
    }

    public ICompletableFuture<E> getAndAlterAsync(IFunction<E, E> function) {
        Span span = this.helper.buildSpan("getAndAlterAsync", (DistributedObject)this.reference);
        span.setTag("function", TracingHelper.nullableClass(function));
        Map<String, String> spanContextMap = TracingHelper.inject(span);
        ICompletableFuture future = this.reference.getAndAlterAsync(new TracingFunction<E, E>(function, this.traceWithActiveSpanOnly, spanContextMap));
        return TracingHelper.decorate(() -> new TracingCompletableFuture(future, this.traceWithActiveSpanOnly, TracingHelper.inject(span)), span);
    }

    public <R> ICompletableFuture<R> applyAsync(IFunction<E, R> function) {
        Span span = this.helper.buildSpan("applyAsync", (DistributedObject)this.reference);
        span.setTag("function", TracingHelper.nullableClass(function));
        Map<String, String> spanContextMap = TracingHelper.inject(span);
        ICompletableFuture future = this.reference.applyAsync(new TracingFunction<E, R>(function, this.traceWithActiveSpanOnly, spanContextMap));
        return TracingHelper.decorate(() -> new TracingCompletableFuture(future, this.traceWithActiveSpanOnly, TracingHelper.inject(span)), span);
    }

    public String getPartitionKey() {
        return this.reference.getPartitionKey();
    }

    public String getName() {
        return this.reference.getName();
    }

    public String getServiceName() {
        return this.reference.getServiceName();
    }

    public void destroy() {
        Span span = this.helper.buildSpan("destroy", (DistributedObject)this.reference);
        TracingHelper.decorateAction(() -> this.reference.destroy(), span);
    }
}

