/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.hazelcast;

import com.hazelcast.core.IAtomicLong;
import com.hazelcast.core.IAtomicReference;
import com.hazelcast.core.ICountDownLatch;
import com.hazelcast.core.ISemaphore;
import com.hazelcast.cp.CPMember;
import com.hazelcast.cp.CPSubsystem;
import com.hazelcast.cp.CPSubsystemManagementService;
import com.hazelcast.cp.lock.FencedLock;
import com.hazelcast.cp.session.CPSessionManagementService;
import io.opentracing.contrib.hazelcast.TracingAtomicLong;
import io.opentracing.contrib.hazelcast.TracingAtomicReference;
import io.opentracing.contrib.hazelcast.TracingCountDownLatch;
import io.opentracing.contrib.hazelcast.TracingSemaphore;

public class TracingCPSubsystem
implements CPSubsystem {
    private final CPSubsystem cpSubsystem;
    private final boolean traceWithActiveSpanOnly;

    public TracingCPSubsystem(CPSubsystem cpSubsystem, boolean traceWithActiveSpanOnly) {
        this.cpSubsystem = cpSubsystem;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
    }

    public IAtomicLong getAtomicLong(String name) {
        return new TracingAtomicLong(this.cpSubsystem.getAtomicLong(name), this.traceWithActiveSpanOnly);
    }

    public <E> IAtomicReference<E> getAtomicReference(String name) {
        return new TracingAtomicReference(this.cpSubsystem.getAtomicReference(name), this.traceWithActiveSpanOnly);
    }

    public ICountDownLatch getCountDownLatch(String name) {
        return new TracingCountDownLatch(this.cpSubsystem.getCountDownLatch(name), this.traceWithActiveSpanOnly);
    }

    public FencedLock getLock(String name) {
        return this.cpSubsystem.getLock(name);
    }

    public ISemaphore getSemaphore(String name) {
        return new TracingSemaphore(this.cpSubsystem.getSemaphore(name), this.traceWithActiveSpanOnly);
    }

    public CPMember getLocalCPMember() {
        return this.cpSubsystem.getLocalCPMember();
    }

    public CPSubsystemManagementService getCPSubsystemManagementService() {
        return this.cpSubsystem.getCPSubsystemManagementService();
    }

    public CPSessionManagementService getCPSessionManagementService() {
        return this.cpSubsystem.getCPSessionManagementService();
    }
}

