/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.hazelcast;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.instance.Node;
import com.hazelcast.spi.NodeAware;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.spi.serialization.SerializationServiceAware;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.contrib.hazelcast.TracingHelper;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.Callable;

public class TracingCallable<V>
implements Callable<V>,
Serializable,
HazelcastInstanceAware,
NodeAware,
SerializationServiceAware {
    private final Callable<V> callable;
    private final boolean traceWithActiveSpanOnly;
    private final Map<String, String> spanContextMap;

    public TracingCallable(Callable<V> callable, boolean traceWithActiveSpanOnly, Map<String, String> spanContextMap) {
        this.callable = callable;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.spanContextMap = spanContextMap;
    }

    @Override
    public V call() throws Exception {
        SpanContext parent = TracingHelper.extract(this.spanContextMap);
        Span span = TracingHelper.buildSpan("call", parent, this.traceWithActiveSpanOnly);
        span.setTag("callable", TracingHelper.nullableClass(this.callable));
        return (V)TracingHelper.decorateExceptionally2(this.callable::call, span);
    }

    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        if (this.callable instanceof HazelcastInstanceAware) {
            ((HazelcastInstanceAware)this.callable).setHazelcastInstance(hazelcastInstance);
        }
    }

    public void setNode(Node node) {
        if (this.callable instanceof NodeAware) {
            ((NodeAware)this.callable).setNode(node);
        }
    }

    public void setSerializationService(SerializationService serializationService) {
        if (this.callable instanceof SerializationServiceAware) {
            ((SerializationServiceAware)this.callable).setSerializationService(serializationService);
        }
    }
}

