/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.hazelcast;

import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.ICompletableFuture;
import io.opentracing.contrib.hazelcast.NoopExecutionCallback;
import io.opentracing.contrib.hazelcast.TracingExecutionCallback;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class TracingCompletableFuture<V>
implements ICompletableFuture<V> {
    private final ICompletableFuture<V> future;
    private final Map<String, String> spanContextMap;
    private final boolean traceWithActiveSpanOnly;

    public TracingCompletableFuture(ICompletableFuture<V> future, boolean traceWithActiveSpanOnly, Map<String, String> spanContextMap) {
        this.future = future;
        this.spanContextMap = spanContextMap;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        future.andThen(new TracingExecutionCallback(new NoopExecutionCallback(), traceWithActiveSpanOnly, spanContextMap));
    }

    public void andThen(ExecutionCallback<V> callback) {
        this.future.andThen(new TracingExecutionCallback<V>(callback, this.traceWithActiveSpanOnly, this.spanContextMap));
    }

    public void andThen(ExecutionCallback<V> callback, Executor executor) {
        this.future.andThen(new TracingExecutionCallback<V>(callback, this.traceWithActiveSpanOnly, this.spanContextMap), executor);
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.future.cancel(mayInterruptIfRunning);
    }

    public boolean isCancelled() {
        return this.future.isCancelled();
    }

    public boolean isDone() {
        return this.future.isDone();
    }

    public V get() throws InterruptedException, ExecutionException {
        return (V)this.future.get();
    }

    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (V)this.future.get(timeout, unit);
    }
}

