/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.hazelcast;

import com.hazelcast.core.ICondition;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.contrib.hazelcast.TracingHelper;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class TracingCondition
implements ICondition {
    private final ICondition condition;
    private final boolean traceWithActiveSpanOnly;
    private final Map<String, String> spanContextMap;
    private final String name;

    public TracingCondition(ICondition condition, String name, boolean traceWithActiveSpanOnly, Map<String, String> spanContextMap) {
        this.condition = condition;
        this.name = name;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.spanContextMap = spanContextMap;
    }

    public void await() throws InterruptedException {
        SpanContext parent = TracingHelper.extract(this.spanContextMap);
        Span span = TracingHelper.buildSpan("await", parent, this.traceWithActiveSpanOnly);
        span.setTag("condition", this.name);
        TracingHelper.decorateActionExceptionally(() -> this.condition.await(), span);
    }

    public void awaitUninterruptibly() {
        SpanContext parent = TracingHelper.extract(this.spanContextMap);
        Span span = TracingHelper.buildSpan("awaitUninterruptibly", parent, this.traceWithActiveSpanOnly);
        span.setTag("condition", this.name);
        TracingHelper.decorateAction(() -> this.condition.awaitUninterruptibly(), span);
    }

    public long awaitNanos(long nanosTimeout) throws InterruptedException {
        SpanContext parent = TracingHelper.extract(this.spanContextMap);
        Span span = TracingHelper.buildSpan("awaitNanos", parent, this.traceWithActiveSpanOnly);
        span.setTag("condition", this.name);
        span.setTag("nanosTimeout", (Number)nanosTimeout);
        return TracingHelper.decorateExceptionally(() -> this.condition.awaitNanos(nanosTimeout), span);
    }

    public boolean await(long time, TimeUnit unit) throws InterruptedException {
        SpanContext parent = TracingHelper.extract(this.spanContextMap);
        Span span = TracingHelper.buildSpan("await", parent, this.traceWithActiveSpanOnly);
        span.setTag("condition", this.name);
        span.setTag("time", (Number)time);
        span.setTag("unit", TracingHelper.nullable((Object)unit));
        return TracingHelper.decorateExceptionally(() -> this.condition.await(time, unit), span);
    }

    public boolean awaitUntil(Date deadline) throws InterruptedException {
        SpanContext parent = TracingHelper.extract(this.spanContextMap);
        Span span = TracingHelper.buildSpan("awaitUntil", parent, this.traceWithActiveSpanOnly);
        span.setTag("condition", this.name);
        span.setTag("deadline", TracingHelper.nullable(deadline));
        return TracingHelper.decorateExceptionally(() -> this.condition.awaitUntil(deadline), span);
    }

    public void signal() {
        SpanContext parent = TracingHelper.extract(this.spanContextMap);
        Span span = TracingHelper.buildSpan("signal", parent, this.traceWithActiveSpanOnly);
        span.setTag("condition", this.name);
        TracingHelper.decorateAction(() -> this.condition.signal(), span);
    }

    public void signalAll() {
        SpanContext parent = TracingHelper.extract(this.spanContextMap);
        Span span = TracingHelper.buildSpan("signalAll", parent, this.traceWithActiveSpanOnly);
        span.setTag("condition", this.name);
        TracingHelper.decorateAction(() -> this.condition.signalAll(), span);
    }
}

