/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.hazelcast;

import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.ICountDownLatch;
import io.opentracing.Span;
import io.opentracing.contrib.hazelcast.TracingHelper;
import java.util.concurrent.TimeUnit;

public class TracingCountDownLatch
implements ICountDownLatch {
    private final ICountDownLatch latch;
    private final TracingHelper helper;

    public TracingCountDownLatch(ICountDownLatch latch, boolean traceWithActiveSpanOnly) {
        this.latch = latch;
        this.helper = new TracingHelper(traceWithActiveSpanOnly);
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        Span span = this.helper.buildSpan("await", (DistributedObject)this.latch);
        span.setTag("timeout", (Number)timeout);
        span.setTag("unit", TracingHelper.nullable((Object)unit));
        return TracingHelper.decorateExceptionally(() -> this.latch.await(timeout, unit), span);
    }

    public void countDown() {
        Span span = this.helper.buildSpan("countDown", (DistributedObject)this.latch);
        TracingHelper.decorateAction(() -> ((ICountDownLatch)this.latch).countDown(), span);
    }

    public int getCount() {
        Span span = this.helper.buildSpan("getCount", (DistributedObject)this.latch);
        return TracingHelper.decorate(() -> ((ICountDownLatch)this.latch).getCount(), span);
    }

    public boolean trySetCount(int count) {
        Span span = this.helper.buildSpan("trySetCount", (DistributedObject)this.latch);
        span.setTag("count", (Number)count);
        return TracingHelper.decorate(() -> this.latch.trySetCount(count), span);
    }

    public String getPartitionKey() {
        return this.latch.getPartitionKey();
    }

    public String getName() {
        return this.latch.getName();
    }

    public String getServiceName() {
        return this.latch.getServiceName();
    }

    public void destroy() {
        Span span = this.helper.buildSpan("destroy", (DistributedObject)this.latch);
        TracingHelper.decorateAction(() -> ((ICountDownLatch)this.latch).destroy(), span);
    }
}

