/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.hazelcast;

import com.hazelcast.map.EntryBackupProcessor;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.contrib.hazelcast.TracingHelper;
import java.util.Map;

public class TracingEntryBackupProcessor<K, V>
implements EntryBackupProcessor<K, V> {
    private final EntryBackupProcessor<K, V> entryBackupProcessor;
    private final boolean traceWithActiveSpanOnly;
    private final Map<String, String> spanContextMap;

    public TracingEntryBackupProcessor(EntryBackupProcessor<K, V> entryBackupProcessor, boolean traceWithActiveSpanOnly, Map<String, String> spanContextMap) {
        this.entryBackupProcessor = entryBackupProcessor;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.spanContextMap = spanContextMap;
    }

    public void processBackup(Map.Entry<K, V> entry) {
        SpanContext parent = TracingHelper.extract(this.spanContextMap);
        Span span = TracingHelper.buildSpan("process", parent, this.traceWithActiveSpanOnly);
        span.setTag("entryBackupProcessor", TracingHelper.nullableClass(this.entryBackupProcessor));
        span.setTag("entry", TracingHelper.nullable(entry));
        TracingHelper.decorateAction(() -> this.entryBackupProcessor.processBackup(entry), span);
    }
}

