/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.hazelcast;

import com.hazelcast.map.EntryBackupProcessor;
import com.hazelcast.map.EntryProcessor;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.contrib.hazelcast.TracingEntryBackupProcessor;
import io.opentracing.contrib.hazelcast.TracingHelper;
import java.util.Map;

public class TracingEntryProcessor<K, V>
implements EntryProcessor<K, V> {
    private final EntryProcessor<K, V> processor;
    private final boolean traceWithActiveSpanOnly;
    private final Map<String, String> spanContextMap;

    public TracingEntryProcessor(EntryProcessor<K, V> processor, boolean traceWithActiveSpanOnly, Map<String, String> spanContextMap) {
        this.processor = processor;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.spanContextMap = spanContextMap;
    }

    public Object process(Map.Entry<K, V> entry) {
        SpanContext parent = TracingHelper.extract(this.spanContextMap);
        Span span = TracingHelper.buildSpan("process", parent, this.traceWithActiveSpanOnly);
        span.setTag("processor", TracingHelper.nullableClass(this.processor));
        span.setTag("entry", TracingHelper.nullable(entry));
        return TracingHelper.decorate(() -> this.processor.process(entry), span);
    }

    public EntryBackupProcessor<K, V> getBackupProcessor() {
        EntryBackupProcessor entryBackupProcessor = this.processor.getBackupProcessor();
        if (entryBackupProcessor != null) {
            return new TracingEntryBackupProcessor(entryBackupProcessor, this.traceWithActiveSpanOnly, this.spanContextMap);
        }
        return null;
    }
}

