/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.hazelcast;

import com.hazelcast.core.ExecutionCallback;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.contrib.hazelcast.TracingHelper;
import java.util.Map;

public class TracingExecutionCallback<V>
implements ExecutionCallback<V> {
    private final ExecutionCallback<V> callback;
    private final Map<String, String> spanContextMap;
    private final boolean traceWithActiveSpanOnly;

    public TracingExecutionCallback(ExecutionCallback<V> callback, boolean traceWithActiveSpanOnly, Map<String, String> spanContextMap) {
        this.callback = callback;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.spanContextMap = spanContextMap;
    }

    public void onResponse(V response) {
        SpanContext parent = TracingHelper.extract(this.spanContextMap);
        Span span = TracingHelper.buildSpan("onResponse", parent, this.traceWithActiveSpanOnly);
        span.setTag("response", TracingHelper.nullable(response));
        span.setTag("callback", TracingHelper.nullableClass(this.callback));
        TracingHelper.decorateAction(() -> this.callback.onResponse(response), span);
    }

    public void onFailure(Throwable t) {
        SpanContext parent = TracingHelper.extract(this.spanContextMap);
        Span span = TracingHelper.buildSpan("onFailure", parent, this.traceWithActiveSpanOnly);
        span.setTag("callback", TracingHelper.nullableClass(this.callback));
        TracingHelper.onError(t, span);
        TracingHelper.decorateAction(() -> this.callback.onFailure(t), span);
    }
}

