/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.hazelcast;

import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberSelector;
import com.hazelcast.core.MultiExecutionCallback;
import com.hazelcast.monitor.LocalExecutorStats;
import io.opentracing.Span;
import io.opentracing.contrib.hazelcast.TracingCallable;
import io.opentracing.contrib.hazelcast.TracingExecutionCallback;
import io.opentracing.contrib.hazelcast.TracingHelper;
import io.opentracing.contrib.hazelcast.TracingMultiExecutionCallback;
import io.opentracing.contrib.hazelcast.TracingRunnable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;

public class TracingExecutorService
implements IExecutorService {
    private final TracingHelper helper;
    private final IExecutorService service;
    private final boolean traceWithActiveSpanOnly;

    public TracingExecutorService(IExecutorService service, boolean traceWithActiveSpanOnly) {
        this.service = service;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.helper = new TracingHelper(traceWithActiveSpanOnly);
    }

    public void execute(Runnable command, MemberSelector memberSelector) {
        Span span = this.helper.buildSpan("execute", (DistributedObject)this.service);
        span.setTag("command", TracingHelper.nullableClass(command));
        span.setTag("memberSelector", TracingHelper.nullableClass(memberSelector));
        Map<String, String> spanContextMap = TracingHelper.inject(span);
        TracingHelper.decorateAction(() -> this.service.execute((Runnable)new TracingRunnable(command, this.traceWithActiveSpanOnly, spanContextMap), memberSelector), span);
    }

    public void executeOnKeyOwner(Runnable command, Object key) {
        Span span = this.helper.buildSpan("executeOnKeyOwner", (DistributedObject)this.service);
        span.setTag("command", TracingHelper.nullableClass(command));
        span.setTag("key", TracingHelper.nullable(key));
        Map<String, String> spanContextMap = TracingHelper.inject(span);
        TracingHelper.decorateAction(() -> this.service.executeOnKeyOwner((Runnable)new TracingRunnable(command, this.traceWithActiveSpanOnly, spanContextMap), key), span);
    }

    public void executeOnMember(Runnable command, Member member) {
        Span span = this.helper.buildSpan("executeOnMember", (DistributedObject)this.service);
        span.setTag("command", TracingHelper.nullableClass(command));
        span.setTag("member", member.getAddress().toString());
        Map<String, String> spanContextMap = TracingHelper.inject(span);
        TracingHelper.decorateAction(() -> this.service.executeOnMember((Runnable)new TracingRunnable(command, this.traceWithActiveSpanOnly, spanContextMap), member), span);
    }

    public void executeOnMembers(Runnable command, Collection<Member> members) {
        Span span = this.helper.buildSpan("executeOnMembers", (DistributedObject)this.service);
        span.setTag("command", TracingHelper.nullableClass(command));
        span.setTag("members", members.stream().map(member -> member.getAddress().toString()).collect(Collectors.joining(", ")));
        Map<String, String> spanContextMap = TracingHelper.inject(span);
        TracingHelper.decorateAction(() -> this.service.executeOnMembers((Runnable)new TracingRunnable(command, this.traceWithActiveSpanOnly, spanContextMap), members), span);
    }

    public void executeOnMembers(Runnable command, MemberSelector memberSelector) {
        Span span = this.helper.buildSpan("executeOnMembers", (DistributedObject)this.service);
        span.setTag("command", TracingHelper.nullableClass(command));
        span.setTag("memberSelector", TracingHelper.nullableClass(memberSelector));
        Map<String, String> spanContextMap = TracingHelper.inject(span);
        TracingHelper.decorateAction(() -> this.service.executeOnMembers((Runnable)new TracingRunnable(command, this.traceWithActiveSpanOnly, spanContextMap), memberSelector), span);
    }

    public void executeOnAllMembers(Runnable command) {
        Span span = this.helper.buildSpan("executeOnAllMembers", (DistributedObject)this.service);
        span.setTag("command", TracingHelper.nullableClass(command));
        Map<String, String> spanContextMap = TracingHelper.inject(span);
        TracingHelper.decorateAction(() -> this.service.executeOnAllMembers((Runnable)new TracingRunnable(command, this.traceWithActiveSpanOnly, spanContextMap)), span);
    }

    public <T> Future<T> submit(Callable<T> task, MemberSelector memberSelector) {
        Span span = this.helper.buildSpan("submit", (DistributedObject)this.service);
        span.setTag("task", TracingHelper.nullableClass(task));
        span.setTag("memberSelector", TracingHelper.nullableClass(memberSelector));
        Map<String, String> spanContextMap = TracingHelper.inject(span);
        return TracingHelper.decorate(() -> this.service.submit(new TracingCallable(task, this.traceWithActiveSpanOnly, spanContextMap), memberSelector), span);
    }

    public <T> Future<T> submitToKeyOwner(Callable<T> task, Object key) {
        Span span = this.helper.buildSpan("submitToKeyOwner", (DistributedObject)this.service);
        span.setTag("task", TracingHelper.nullableClass(task));
        span.setTag("key", TracingHelper.nullable(key));
        Map<String, String> spanContextMap = TracingHelper.inject(span);
        return TracingHelper.decorate(() -> this.service.submitToKeyOwner(new TracingCallable(task, this.traceWithActiveSpanOnly, spanContextMap), key), span);
    }

    public <T> Future<T> submitToMember(Callable<T> task, Member member) {
        Span span = this.helper.buildSpan("submitToMember", (DistributedObject)this.service);
        span.setTag("task", TracingHelper.nullableClass(task));
        span.setTag("member", member.getAddress().toString());
        Map<String, String> spanContextMap = TracingHelper.inject(span);
        return TracingHelper.decorate(() -> this.service.submitToMember(new TracingCallable(task, this.traceWithActiveSpanOnly, spanContextMap), member), span);
    }

    public <T> Map<Member, Future<T>> submitToMembers(Callable<T> task, Collection<Member> members) {
        Span span = this.helper.buildSpan("submitToMembers", (DistributedObject)this.service);
        span.setTag("task", TracingHelper.nullableClass(task));
        span.setTag("members", members.stream().map(member -> member.getAddress().toString()).collect(Collectors.joining(", ")));
        Map<String, String> spanContextMap = TracingHelper.inject(span);
        return TracingHelper.decorate(() -> this.service.submitToMembers(new TracingCallable(task, this.traceWithActiveSpanOnly, spanContextMap), members), span);
    }

    public <T> Map<Member, Future<T>> submitToMembers(Callable<T> task, MemberSelector memberSelector) {
        Span span = this.helper.buildSpan("submitToMembers", (DistributedObject)this.service);
        span.setTag("task", TracingHelper.nullableClass(task));
        span.setTag("memberSelector", TracingHelper.nullableClass(memberSelector));
        Map<String, String> spanContextMap = TracingHelper.inject(span);
        return TracingHelper.decorate(() -> this.service.submitToMembers(new TracingCallable(task, this.traceWithActiveSpanOnly, spanContextMap), memberSelector), span);
    }

    public <T> Map<Member, Future<T>> submitToAllMembers(Callable<T> task) {
        Span span = this.helper.buildSpan("submitToAllMembers", (DistributedObject)this.service);
        span.setTag("task", TracingHelper.nullableClass(task));
        Map<String, String> spanContextMap = TracingHelper.inject(span);
        return TracingHelper.decorate(() -> this.service.submitToAllMembers(new TracingCallable(task, this.traceWithActiveSpanOnly, spanContextMap)), span);
    }

    public <T> void submit(Runnable task, ExecutionCallback<T> callback) {
        Span span = this.helper.buildSpan("submit", (DistributedObject)this.service);
        span.setTag("task", TracingHelper.nullableClass(task));
        span.setTag("callback", TracingHelper.nullableClass(callback));
        Map<String, String> spanContextMap = TracingHelper.inject(span);
        TracingRunnable tracingRunnable = new TracingRunnable(task, this.traceWithActiveSpanOnly, spanContextMap);
        TracingExecutionCallback tracingExecutionCallback = new TracingExecutionCallback(callback, this.traceWithActiveSpanOnly, spanContextMap);
        TracingHelper.decorateAction(() -> this.service.submit((Runnable)tracingRunnable, (ExecutionCallback)tracingExecutionCallback), span);
    }

    public <T> void submit(Runnable task, MemberSelector memberSelector, ExecutionCallback<T> callback) {
        Span span = this.helper.buildSpan("submit", (DistributedObject)this.service);
        span.setTag("task", TracingHelper.nullableClass(task));
        span.setTag("callback", TracingHelper.nullableClass(callback));
        span.setTag("memberSelector", TracingHelper.nullableClass(memberSelector));
        Map<String, String> spanContextMap = TracingHelper.inject(span);
        TracingRunnable tracingRunnable = new TracingRunnable(task, this.traceWithActiveSpanOnly, spanContextMap);
        TracingExecutionCallback tracingExecutionCallback = new TracingExecutionCallback(callback, this.traceWithActiveSpanOnly, spanContextMap);
        TracingHelper.decorateAction(() -> this.service.submit((Runnable)tracingRunnable, memberSelector, (ExecutionCallback)tracingExecutionCallback), span);
    }

    public <T> void submitToKeyOwner(Runnable task, Object key, ExecutionCallback<T> callback) {
        Span span = this.helper.buildSpan("submitToKeyOwner", (DistributedObject)this.service);
        span.setTag("task", TracingHelper.nullableClass(task));
        span.setTag("callback", TracingHelper.nullableClass(callback));
        span.setTag("key", TracingHelper.nullable(key));
        Map<String, String> spanContextMap = TracingHelper.inject(span);
        TracingRunnable tracingRunnable = new TracingRunnable(task, this.traceWithActiveSpanOnly, spanContextMap);
        TracingExecutionCallback tracingExecutionCallback = new TracingExecutionCallback(callback, this.traceWithActiveSpanOnly, spanContextMap);
        TracingHelper.decorateAction(() -> this.service.submitToKeyOwner((Runnable)tracingRunnable, key, (ExecutionCallback)tracingExecutionCallback), span);
    }

    public <T> void submitToMember(Runnable task, Member member, ExecutionCallback<T> callback) {
        Span span = this.helper.buildSpan("submitToMember", (DistributedObject)this.service);
        span.setTag("task", TracingHelper.nullableClass(task));
        span.setTag("callback", TracingHelper.nullableClass(callback));
        span.setTag("member", member.getAddress().toString());
        Map<String, String> spanContextMap = TracingHelper.inject(span);
        TracingRunnable tracingRunnable = new TracingRunnable(task, this.traceWithActiveSpanOnly, spanContextMap);
        TracingExecutionCallback tracingExecutionCallback = new TracingExecutionCallback(callback, this.traceWithActiveSpanOnly, spanContextMap);
        TracingHelper.decorateAction(() -> this.service.submitToMember((Runnable)tracingRunnable, member, (ExecutionCallback)tracingExecutionCallback), span);
    }

    public void submitToMembers(Runnable task, Collection<Member> members, MultiExecutionCallback callback) {
        Span span = this.helper.buildSpan("submitToMembers", (DistributedObject)this.service);
        span.setTag("task", TracingHelper.nullableClass(task));
        span.setTag("callback", TracingHelper.nullableClass(callback));
        span.setTag("members", members.stream().map(member -> member.getAddress().toString()).collect(Collectors.joining(", ")));
        Map<String, String> spanContextMap = TracingHelper.inject(span);
        TracingRunnable tracingRunnable = new TracingRunnable(task, this.traceWithActiveSpanOnly, spanContextMap);
        TracingMultiExecutionCallback tracingExecutionCallback = new TracingMultiExecutionCallback(callback, this.traceWithActiveSpanOnly, spanContextMap);
        TracingHelper.decorateAction(() -> this.service.submitToMembers((Runnable)tracingRunnable, members, (MultiExecutionCallback)tracingExecutionCallback), span);
    }

    public void submitToMembers(Runnable task, MemberSelector memberSelector, MultiExecutionCallback callback) {
        Span span = this.helper.buildSpan("submitToMembers", (DistributedObject)this.service);
        span.setTag("task", TracingHelper.nullableClass(task));
        span.setTag("callback", TracingHelper.nullableClass(callback));
        span.setTag("memberSelector", TracingHelper.nullableClass(memberSelector));
        Map<String, String> spanContextMap = TracingHelper.inject(span);
        TracingRunnable tracingRunnable = new TracingRunnable(task, this.traceWithActiveSpanOnly, spanContextMap);
        TracingMultiExecutionCallback tracingExecutionCallback = new TracingMultiExecutionCallback(callback, this.traceWithActiveSpanOnly, spanContextMap);
        TracingHelper.decorateAction(() -> this.service.submitToMembers((Runnable)tracingRunnable, memberSelector, (MultiExecutionCallback)tracingExecutionCallback), span);
    }

    public void submitToAllMembers(Runnable task, MultiExecutionCallback callback) {
        Span span = this.helper.buildSpan("submitToAllMembers", (DistributedObject)this.service);
        span.setTag("task", TracingHelper.nullableClass(task));
        span.setTag("callback", TracingHelper.nullableClass(callback));
        Map<String, String> spanContextMap = TracingHelper.inject(span);
        TracingRunnable tracingRunnable = new TracingRunnable(task, this.traceWithActiveSpanOnly, spanContextMap);
        TracingMultiExecutionCallback tracingExecutionCallback = new TracingMultiExecutionCallback(callback, this.traceWithActiveSpanOnly, spanContextMap);
        TracingHelper.decorateAction(() -> this.service.submitToAllMembers((Runnable)tracingRunnable, (MultiExecutionCallback)tracingExecutionCallback), span);
    }

    public <T> void submit(Callable<T> task, ExecutionCallback<T> callback) {
        Span span = this.helper.buildSpan("submit", (DistributedObject)this.service);
        span.setTag("task", TracingHelper.nullableClass(task));
        span.setTag("callback", TracingHelper.nullableClass(callback));
        Map<String, String> spanContextMap = TracingHelper.inject(span);
        TracingCallable tracingCallable = new TracingCallable(task, this.traceWithActiveSpanOnly, spanContextMap);
        TracingExecutionCallback tracingExecutionCallback = new TracingExecutionCallback(callback, this.traceWithActiveSpanOnly, spanContextMap);
        TracingHelper.decorateAction(() -> this.service.submit((Callable)tracingCallable, (ExecutionCallback)tracingExecutionCallback), span);
    }

    public <T> void submit(Callable<T> task, MemberSelector memberSelector, ExecutionCallback<T> callback) {
        Span span = this.helper.buildSpan("submit", (DistributedObject)this.service);
        span.setTag("task", TracingHelper.nullableClass(task));
        span.setTag("callback", TracingHelper.nullableClass(callback));
        span.setTag("memberSelector", TracingHelper.nullableClass(memberSelector));
        Map<String, String> spanContextMap = TracingHelper.inject(span);
        TracingCallable tracingCallable = new TracingCallable(task, this.traceWithActiveSpanOnly, spanContextMap);
        TracingExecutionCallback tracingExecutionCallback = new TracingExecutionCallback(callback, this.traceWithActiveSpanOnly, spanContextMap);
        TracingHelper.decorateAction(() -> this.service.submit((Callable)tracingCallable, memberSelector, (ExecutionCallback)tracingExecutionCallback), span);
    }

    public <T> void submitToKeyOwner(Callable<T> task, Object key, ExecutionCallback<T> callback) {
        Span span = this.helper.buildSpan("submitToKeyOwner", (DistributedObject)this.service);
        span.setTag("task", TracingHelper.nullableClass(task));
        span.setTag("callback", TracingHelper.nullableClass(callback));
        span.setTag("key", TracingHelper.nullable(key));
        Map<String, String> spanContextMap = TracingHelper.inject(span);
        TracingCallable tracingCallable = new TracingCallable(task, this.traceWithActiveSpanOnly, spanContextMap);
        TracingExecutionCallback tracingExecutionCallback = new TracingExecutionCallback(callback, this.traceWithActiveSpanOnly, spanContextMap);
        TracingHelper.decorateAction(() -> this.service.submitToKeyOwner((Callable)tracingCallable, key, (ExecutionCallback)tracingExecutionCallback), span);
    }

    public <T> void submitToMember(Callable<T> task, Member member, ExecutionCallback<T> callback) {
        Span span = this.helper.buildSpan("submitToMember", (DistributedObject)this.service);
        span.setTag("task", TracingHelper.nullableClass(task));
        span.setTag("callback", TracingHelper.nullableClass(callback));
        span.setTag("member", member.getAddress().toString());
        Map<String, String> spanContextMap = TracingHelper.inject(span);
        TracingCallable tracingCallable = new TracingCallable(task, this.traceWithActiveSpanOnly, spanContextMap);
        TracingExecutionCallback tracingExecutionCallback = new TracingExecutionCallback(callback, this.traceWithActiveSpanOnly, spanContextMap);
        TracingHelper.decorateAction(() -> this.service.submitToMember((Callable)tracingCallable, member, (ExecutionCallback)tracingExecutionCallback), span);
    }

    public <T> void submitToMembers(Callable<T> task, Collection<Member> members, MultiExecutionCallback callback) {
        Span span = this.helper.buildSpan("submitToMembers", (DistributedObject)this.service);
        span.setTag("task", TracingHelper.nullableClass(task));
        span.setTag("callback", TracingHelper.nullableClass(callback));
        span.setTag("members", members.stream().map(member -> member.getAddress().toString()).collect(Collectors.joining(", ")));
        Map<String, String> spanContextMap = TracingHelper.inject(span);
        TracingCallable tracingCallable = new TracingCallable(task, this.traceWithActiveSpanOnly, spanContextMap);
        TracingMultiExecutionCallback tracingExecutionCallback = new TracingMultiExecutionCallback(callback, this.traceWithActiveSpanOnly, spanContextMap);
        TracingHelper.decorateAction(() -> this.service.submitToMembers((Callable)tracingCallable, members, (MultiExecutionCallback)tracingExecutionCallback), span);
    }

    public <T> void submitToMembers(Callable<T> task, MemberSelector memberSelector, MultiExecutionCallback callback) {
        Span span = this.helper.buildSpan("submitToMembers", (DistributedObject)this.service);
        span.setTag("task", TracingHelper.nullableClass(task));
        span.setTag("callback", TracingHelper.nullableClass(callback));
        span.setTag("memberSelector", TracingHelper.nullableClass(memberSelector));
        Map<String, String> spanContextMap = TracingHelper.inject(span);
        TracingCallable tracingCallable = new TracingCallable(task, this.traceWithActiveSpanOnly, spanContextMap);
        TracingMultiExecutionCallback tracingExecutionCallback = new TracingMultiExecutionCallback(callback, this.traceWithActiveSpanOnly, spanContextMap);
        TracingHelper.decorateAction(() -> this.service.submitToMembers((Callable)tracingCallable, memberSelector, (MultiExecutionCallback)tracingExecutionCallback), span);
    }

    public <T> void submitToAllMembers(Callable<T> task, MultiExecutionCallback callback) {
        Span span = this.helper.buildSpan("submitToAllMembers", (DistributedObject)this.service);
        span.setTag("task", TracingHelper.nullableClass(task));
        span.setTag("callback", TracingHelper.nullableClass(callback));
        Map<String, String> spanContextMap = TracingHelper.inject(span);
        TracingCallable tracingCallable = new TracingCallable(task, this.traceWithActiveSpanOnly, spanContextMap);
        TracingMultiExecutionCallback tracingExecutionCallback = new TracingMultiExecutionCallback(callback, this.traceWithActiveSpanOnly, spanContextMap);
        TracingHelper.decorateAction(() -> this.service.submitToAllMembers((Callable)tracingCallable, (MultiExecutionCallback)tracingExecutionCallback), span);
    }

    public LocalExecutorStats getLocalExecutorStats() {
        return this.service.getLocalExecutorStats();
    }

    public void shutdown() {
        Span span = this.helper.buildSpan("shutdown", (DistributedObject)this.service);
        TracingHelper.decorateAction(() -> this.service.shutdown(), span);
    }

    public List<Runnable> shutdownNow() {
        Span span = this.helper.buildSpan("shutdownNow", (DistributedObject)this.service);
        return TracingHelper.decorate(() -> this.service.shutdownNow(), span);
    }

    public boolean isShutdown() {
        Span span = this.helper.buildSpan("isShutdown", (DistributedObject)this.service);
        return TracingHelper.decorate(() -> this.service.isShutdown(), span);
    }

    public boolean isTerminated() {
        Span span = this.helper.buildSpan("isTerminated", (DistributedObject)this.service);
        return TracingHelper.decorate(() -> this.service.isTerminated(), span);
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        Span span = this.helper.buildSpan("awaitTermination", (DistributedObject)this.service);
        span.setTag("timeout", (Number)timeout);
        span.setTag("timeUnit", TracingHelper.nullable((Object)unit));
        return TracingHelper.decorateExceptionally(() -> this.service.awaitTermination(timeout, unit), span);
    }

    public <T> Future<T> submit(Callable<T> task) {
        Span span = this.helper.buildSpan("submit", (DistributedObject)this.service);
        span.setTag("task", TracingHelper.nullableClass(task));
        Map<String, String> spanContextMap = TracingHelper.inject(span);
        TracingCallable tracingCallable = new TracingCallable(task, this.traceWithActiveSpanOnly, spanContextMap);
        return TracingHelper.decorate(() -> this.service.submit((Callable)tracingCallable), span);
    }

    public <T> Future<T> submit(Runnable task, T result) {
        Span span = this.helper.buildSpan("submit", (DistributedObject)this.service);
        span.setTag("task", TracingHelper.nullableClass(task));
        span.setTag("result", TracingHelper.nullable(result));
        Map<String, String> spanContextMap = TracingHelper.inject(span);
        TracingRunnable tracingRunnable = new TracingRunnable(task, this.traceWithActiveSpanOnly, spanContextMap);
        return TracingHelper.decorate(() -> this.service.submit((Runnable)tracingRunnable, result), span);
    }

    public Future<?> submit(Runnable task) {
        Span span = this.helper.buildSpan("submit", (DistributedObject)this.service);
        span.setTag("task", TracingHelper.nullableClass(task));
        Map<String, String> spanContextMap = TracingHelper.inject(span);
        return TracingHelper.decorate(() -> this.service.submit((Runnable)new TracingRunnable(task, this.traceWithActiveSpanOnly, spanContextMap)), span);
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        Span span = this.helper.buildSpan("invokeAll", (DistributedObject)this.service);
        span.setTag("tasks", TracingHelper.nullableClass(tasks));
        Map<String, String> spanContextMap = TracingHelper.inject(span);
        List tracingCallables = tasks.stream().map(task -> new TracingCallable(task, this.traceWithActiveSpanOnly, spanContextMap)).collect(Collectors.toList());
        return TracingHelper.decorateExceptionally(() -> this.service.invokeAll((Collection)tracingCallables), span);
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        Span span = this.helper.buildSpan("invokeAll", (DistributedObject)this.service);
        span.setTag("tasks", TracingHelper.nullableClass(tasks));
        span.setTag("timeout", (Number)timeout);
        span.setTag("unit", TracingHelper.nullableClass((Object)unit));
        Map<String, String> spanContextMap = TracingHelper.inject(span);
        List tracingCallables = tasks.stream().map(task -> new TracingCallable(task, this.traceWithActiveSpanOnly, spanContextMap)).collect(Collectors.toList());
        return TracingHelper.decorateExceptionally(() -> this.service.invokeAll((Collection)tracingCallables, timeout, unit), span);
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        Span span = this.helper.buildSpan("invokeAny", (DistributedObject)this.service);
        span.setTag("tasks", TracingHelper.nullableClass(tasks));
        Map<String, String> spanContextMap = TracingHelper.inject(span);
        List tracingCallables = tasks.stream().map(task -> new TracingCallable(task, this.traceWithActiveSpanOnly, spanContextMap)).collect(Collectors.toList());
        return (T)TracingHelper.decorateExceptionally3(() -> this.service.invokeAny((Collection)tracingCallables), span);
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Span span = this.helper.buildSpan("invokeAny", (DistributedObject)this.service);
        span.setTag("tasks", TracingHelper.nullableClass(tasks));
        span.setTag("timeout", (Number)timeout);
        span.setTag("unit", TracingHelper.nullableClass((Object)unit));
        Map<String, String> spanContextMap = TracingHelper.inject(span);
        List tracingCallables = tasks.stream().map(task -> new TracingCallable(task, this.traceWithActiveSpanOnly, spanContextMap)).collect(Collectors.toList());
        return (T)TracingHelper.decorateExceptionally4(() -> this.service.invokeAny((Collection)tracingCallables, timeout, unit), span);
    }

    public void execute(Runnable command) {
        Span span = this.helper.buildSpan("execute", (DistributedObject)this.service);
        span.setTag("command", TracingHelper.nullableClass(command));
        Map<String, String> spanContextMap = TracingHelper.inject(span);
        TracingRunnable tracingRunnable = new TracingRunnable(command, this.traceWithActiveSpanOnly, spanContextMap);
        TracingHelper.decorateAction(() -> this.service.execute((Runnable)tracingRunnable), span);
    }

    public String getPartitionKey() {
        return this.service.getPartitionKey();
    }

    public String getName() {
        return this.service.getName();
    }

    public String getServiceName() {
        return this.service.getServiceName();
    }

    public void destroy() {
        Span span = this.helper.buildSpan("destroy", (DistributedObject)this.service);
        TracingHelper.decorateAction(() -> ((IExecutorService)this.service).destroy(), span);
    }
}

