/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.hazelcast;

import com.hazelcast.core.IFunction;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.contrib.hazelcast.TracingHelper;
import java.util.Map;

public class TracingFunction<T, R>
implements IFunction<T, R> {
    private final IFunction<T, R> function;
    private final boolean traceWithActiveSpanOnly;
    private final Map<String, String> spanContextMap;

    public TracingFunction(IFunction<T, R> function, boolean traceWithActiveSpanOnly, Map<String, String> spanContextMap) {
        this.function = function;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.spanContextMap = spanContextMap;
    }

    public R apply(T input) {
        SpanContext parent = TracingHelper.extract(this.spanContextMap);
        Span span = TracingHelper.buildSpan("apply", parent, this.traceWithActiveSpanOnly);
        span.setTag("function", TracingHelper.nullableClass(this.function));
        return (R)TracingHelper.decorate(() -> this.function.apply(input), span);
    }
}

