/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.hazelcast;

import com.hazelcast.cardinality.CardinalityEstimator;
import com.hazelcast.config.Config;
import com.hazelcast.core.ClientService;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.DistributedObjectListener;
import com.hazelcast.core.Endpoint;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.core.IAtomicReference;
import com.hazelcast.core.ICacheManager;
import com.hazelcast.core.ICountDownLatch;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.IList;
import com.hazelcast.core.ILock;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ISemaphore;
import com.hazelcast.core.ISet;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.IdGenerator;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.core.MultiMap;
import com.hazelcast.core.PartitionService;
import com.hazelcast.core.ReplicatedMap;
import com.hazelcast.cp.CPSubsystem;
import com.hazelcast.crdt.pncounter.PNCounter;
import com.hazelcast.durableexecutor.DurableExecutorService;
import com.hazelcast.flakeidgen.FlakeIdGenerator;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.mapreduce.JobTracker;
import com.hazelcast.quorum.QuorumService;
import com.hazelcast.ringbuffer.Ringbuffer;
import com.hazelcast.scheduledexecutor.IScheduledExecutorService;
import com.hazelcast.transaction.HazelcastXAResource;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionOptions;
import com.hazelcast.transaction.TransactionalTask;
import io.opentracing.Span;
import io.opentracing.contrib.hazelcast.TracingAtomicLong;
import io.opentracing.contrib.hazelcast.TracingAtomicReference;
import io.opentracing.contrib.hazelcast.TracingCPSubsystem;
import io.opentracing.contrib.hazelcast.TracingCountDownLatch;
import io.opentracing.contrib.hazelcast.TracingExecutorService;
import io.opentracing.contrib.hazelcast.TracingHelper;
import io.opentracing.contrib.hazelcast.TracingList;
import io.opentracing.contrib.hazelcast.TracingLock;
import io.opentracing.contrib.hazelcast.TracingMap;
import io.opentracing.contrib.hazelcast.TracingMultiMap;
import io.opentracing.contrib.hazelcast.TracingQueue;
import io.opentracing.contrib.hazelcast.TracingReplicatedMap;
import io.opentracing.contrib.hazelcast.TracingRingbuffer;
import io.opentracing.contrib.hazelcast.TracingSemaphore;
import io.opentracing.contrib.hazelcast.TracingSet;
import io.opentracing.contrib.hazelcast.TracingTopic;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;

public class TracingHazelcastInstance
implements HazelcastInstance {
    private final HazelcastInstance instance;
    private final boolean traceWithActiveSpanOnly;
    private final TracingHelper helper;

    public TracingHazelcastInstance(HazelcastInstance instance, boolean traceWithActiveSpanOnly) {
        this.instance = instance;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.helper = new TracingHelper(traceWithActiveSpanOnly);
    }

    public String getName() {
        return this.instance.getName();
    }

    public <E> IQueue<E> getQueue(String s) {
        return new TracingQueue(this.instance.getQueue(s), this.traceWithActiveSpanOnly);
    }

    public <E> ITopic<E> getTopic(String topic) {
        return new TracingTopic(topic, false, this.instance, this.traceWithActiveSpanOnly);
    }

    public <E> ISet<E> getSet(String s) {
        return new TracingSet(this.instance.getSet(s), this.traceWithActiveSpanOnly);
    }

    public <E> IList<E> getList(String s) {
        return new TracingList(this.instance.getList(s), this.traceWithActiveSpanOnly);
    }

    public <K, V> IMap<K, V> getMap(String s) {
        return new TracingMap(this.instance.getMap(s), this.traceWithActiveSpanOnly);
    }

    public <K, V> ReplicatedMap<K, V> getReplicatedMap(String s) {
        return new TracingReplicatedMap(this.instance.getReplicatedMap(s), this.traceWithActiveSpanOnly);
    }

    @Deprecated
    public JobTracker getJobTracker(String s) {
        return this.instance.getJobTracker(s);
    }

    public <K, V> MultiMap<K, V> getMultiMap(String s) {
        return new TracingMultiMap(this.instance.getMultiMap(s), this.traceWithActiveSpanOnly);
    }

    public ILock getLock(String s) {
        return new TracingLock(this.instance.getLock(s), this.traceWithActiveSpanOnly);
    }

    public <E> Ringbuffer<E> getRingbuffer(String s) {
        return new TracingRingbuffer(this.instance.getRingbuffer(s), this.traceWithActiveSpanOnly);
    }

    public <E> ITopic<E> getReliableTopic(String s) {
        return new TracingTopic(s, true, this.instance, this.traceWithActiveSpanOnly);
    }

    public Cluster getCluster() {
        return this.instance.getCluster();
    }

    public Endpoint getLocalEndpoint() {
        return this.instance.getLocalEndpoint();
    }

    public IExecutorService getExecutorService(String s) {
        return new TracingExecutorService(this.instance.getExecutorService(s), this.traceWithActiveSpanOnly);
    }

    public DurableExecutorService getDurableExecutorService(String s) {
        return this.instance.getDurableExecutorService(s);
    }

    public <T> T executeTransaction(TransactionalTask<T> transactionalTask) throws TransactionException {
        Span span = this.helper.buildSpan("executeTransaction");
        span.setTag("transactionalTask", TracingHelper.nullableClass(transactionalTask));
        return (T)TracingHelper.decorate(() -> this.instance.executeTransaction(transactionalTask), span);
    }

    public <T> T executeTransaction(TransactionOptions transactionOptions, TransactionalTask<T> transactionalTask) throws TransactionException {
        Span span = this.helper.buildSpan("executeTransaction");
        span.setTag("transactionOptions", TracingHelper.nullable(transactionOptions));
        span.setTag("transactionalTask", TracingHelper.nullableClass(transactionalTask));
        return (T)TracingHelper.decorate(() -> this.instance.executeTransaction(transactionOptions, transactionalTask), span);
    }

    public TransactionContext newTransactionContext() {
        return this.instance.newTransactionContext();
    }

    public TransactionContext newTransactionContext(TransactionOptions transactionOptions) {
        return this.instance.newTransactionContext(transactionOptions);
    }

    public IdGenerator getIdGenerator(String s) {
        return this.instance.getIdGenerator(s);
    }

    public FlakeIdGenerator getFlakeIdGenerator(String name) {
        return this.instance.getFlakeIdGenerator(name);
    }

    public IAtomicLong getAtomicLong(String s) {
        return new TracingAtomicLong(this.instance.getAtomicLong(s), this.traceWithActiveSpanOnly);
    }

    public <E> IAtomicReference<E> getAtomicReference(String s) {
        return new TracingAtomicReference(this.instance.getAtomicReference(s), this.traceWithActiveSpanOnly);
    }

    public ICountDownLatch getCountDownLatch(String s) {
        return new TracingCountDownLatch(this.instance.getCountDownLatch(s), this.traceWithActiveSpanOnly);
    }

    public ISemaphore getSemaphore(String s) {
        return new TracingSemaphore(this.instance.getSemaphore(s), this.traceWithActiveSpanOnly);
    }

    public Collection<DistributedObject> getDistributedObjects() {
        return this.instance.getDistributedObjects();
    }

    public String addDistributedObjectListener(DistributedObjectListener distributedObjectListener) {
        return this.instance.addDistributedObjectListener(distributedObjectListener);
    }

    public boolean removeDistributedObjectListener(String s) {
        return this.instance.removeDistributedObjectListener(s);
    }

    public Config getConfig() {
        return this.instance.getConfig();
    }

    public PartitionService getPartitionService() {
        return this.instance.getPartitionService();
    }

    public QuorumService getQuorumService() {
        return this.instance.getQuorumService();
    }

    public ClientService getClientService() {
        return this.instance.getClientService();
    }

    public LoggingService getLoggingService() {
        return this.instance.getLoggingService();
    }

    public LifecycleService getLifecycleService() {
        return this.instance.getLifecycleService();
    }

    public <T extends DistributedObject> T getDistributedObject(String serviceName, String name) {
        return (T)this.instance.getDistributedObject(serviceName, name);
    }

    public ConcurrentMap<String, Object> getUserContext() {
        return this.instance.getUserContext();
    }

    public HazelcastXAResource getXAResource() {
        return this.instance.getXAResource();
    }

    public ICacheManager getCacheManager() {
        return this.instance.getCacheManager();
    }

    public CardinalityEstimator getCardinalityEstimator(String s) {
        return this.instance.getCardinalityEstimator(s);
    }

    public PNCounter getPNCounter(String name) {
        return this.instance.getPNCounter(name);
    }

    public IScheduledExecutorService getScheduledExecutorService(String s) {
        return this.instance.getScheduledExecutorService(s);
    }

    public CPSubsystem getCPSubsystem() {
        return new TracingCPSubsystem(this.instance.getCPSubsystem(), this.traceWithActiveSpanOnly);
    }

    public void shutdown() {
        this.instance.shutdown();
    }
}

