/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.hazelcast;

import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.IList;
import com.hazelcast.core.ItemListener;
import io.opentracing.Span;
import io.opentracing.contrib.hazelcast.TracingHelper;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;

public class TracingList<E>
implements IList<E> {
    private final IList<E> list;
    private final boolean traceWithActiveSpanOnly;
    private final TracingHelper helper;

    public TracingList(IList<E> list, boolean traceWithActiveSpanOnly) {
        this.list = list;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.helper = new TracingHelper(traceWithActiveSpanOnly);
    }

    public int size() {
        Span span = this.helper.buildSpan("size", (DistributedObject)this.list);
        return TracingHelper.decorate(() -> this.list.size(), span);
    }

    public boolean isEmpty() {
        Span span = this.helper.buildSpan("isEmpty", (DistributedObject)this.list);
        return TracingHelper.decorate(() -> this.list.isEmpty(), span);
    }

    public boolean contains(Object element) {
        Span span = this.helper.buildSpan("contains", (DistributedObject)this.list);
        span.setTag("element", TracingHelper.nullable(element));
        return TracingHelper.decorate(() -> this.list.contains(element), span);
    }

    public Iterator<E> iterator() {
        Span span = this.helper.buildSpan("iterator", (DistributedObject)this.list);
        return TracingHelper.decorate(() -> this.list.iterator(), span);
    }

    public Object[] toArray() {
        Span span = this.helper.buildSpan("toArray", (DistributedObject)this.list);
        return TracingHelper.decorate(() -> this.list.toArray(), span);
    }

    public <T> T[] toArray(T[] a) {
        Span span = this.helper.buildSpan("toArray", (DistributedObject)this.list);
        return TracingHelper.decorate(() -> this.list.toArray(a), span);
    }

    public boolean add(E element) {
        Span span = this.helper.buildSpan("add", (DistributedObject)this.list);
        span.setTag("element", TracingHelper.nullable(element));
        return TracingHelper.decorate(() -> this.list.add(element), span);
    }

    public boolean remove(Object element) {
        Span span = this.helper.buildSpan("remove", (DistributedObject)this.list);
        span.setTag("element", TracingHelper.nullable(element));
        return TracingHelper.decorate(() -> this.list.remove(element), span);
    }

    public boolean containsAll(Collection<?> collection) {
        Span span = this.helper.buildSpan("containsAll", (DistributedObject)this.list);
        span.setTag("collection", TracingHelper.nullable(collection));
        return TracingHelper.decorate(() -> this.list.containsAll(collection), span);
    }

    public boolean addAll(Collection<? extends E> collection) {
        Span span = this.helper.buildSpan("addAll", (DistributedObject)this.list);
        span.setTag("collection", TracingHelper.nullable(collection));
        return TracingHelper.decorate(() -> this.list.addAll(collection), span);
    }

    public boolean addAll(int index, Collection<? extends E> collection) {
        Span span = this.helper.buildSpan("addAll", (DistributedObject)this.list);
        span.setTag("index", (Number)index);
        span.setTag("collection", TracingHelper.nullable(collection));
        return TracingHelper.decorate(() -> this.list.addAll(index, collection), span);
    }

    public boolean removeAll(Collection<?> collection) {
        Span span = this.helper.buildSpan("removeAll", (DistributedObject)this.list);
        span.setTag("collection", TracingHelper.nullable(collection));
        return TracingHelper.decorate(() -> this.list.removeAll(collection), span);
    }

    public boolean retainAll(Collection<?> collection) {
        Span span = this.helper.buildSpan("retainAll", (DistributedObject)this.list);
        span.setTag("collection", TracingHelper.nullable(collection));
        return TracingHelper.decorate(() -> this.list.retainAll(collection), span);
    }

    public void replaceAll(UnaryOperator<E> operator) {
        Span span = this.helper.buildSpan("replaceAll", (DistributedObject)this.list);
        span.setTag("operator", TracingHelper.nullableClass(operator));
        TracingHelper.decorateAction(() -> this.list.replaceAll(operator), span);
    }

    public void sort(Comparator<? super E> c) {
        Span span = this.helper.buildSpan("clear", (DistributedObject)this.list);
        span.setTag("comparator", TracingHelper.nullableClass(c));
        TracingHelper.decorateAction(() -> this.list.sort(c), span);
    }

    public void clear() {
        Span span = this.helper.buildSpan("clear", (DistributedObject)this.list);
        TracingHelper.decorateAction(() -> this.list.clear(), span);
    }

    public boolean equals(Object o) {
        return this.list.equals(o);
    }

    public int hashCode() {
        return this.list.hashCode();
    }

    public E get(int index) {
        Span span = this.helper.buildSpan("get", (DistributedObject)this.list);
        span.setTag("index", (Number)index);
        return (E)TracingHelper.decorate(() -> this.list.get(index), span);
    }

    public E set(int index, E element) {
        Span span = this.helper.buildSpan("set", (DistributedObject)this.list);
        span.setTag("index", (Number)index);
        span.setTag("element", TracingHelper.nullable(element));
        return (E)TracingHelper.decorate(() -> this.list.set(index, element), span);
    }

    public void add(int index, E element) {
        Span span = this.helper.buildSpan("add", (DistributedObject)this.list);
        span.setTag("index", (Number)index);
        span.setTag("element", TracingHelper.nullable(element));
        TracingHelper.decorateAction(() -> this.list.add(index, element), span);
    }

    public E remove(int index) {
        Span span = this.helper.buildSpan("remove", (DistributedObject)this.list);
        span.setTag("index", (Number)index);
        return (E)TracingHelper.decorate(() -> this.list.remove(index), span);
    }

    public int indexOf(Object element) {
        Span span = this.helper.buildSpan("indexOf", (DistributedObject)this.list);
        span.setTag("element", TracingHelper.nullable(element));
        return TracingHelper.decorate(() -> this.list.indexOf(element), span);
    }

    public int lastIndexOf(Object element) {
        Span span = this.helper.buildSpan("lastIndexOf", (DistributedObject)this.list);
        span.setTag("element", TracingHelper.nullable(element));
        return TracingHelper.decorate(() -> this.list.lastIndexOf(element), span);
    }

    public ListIterator<E> listIterator() {
        return this.list.listIterator();
    }

    public ListIterator<E> listIterator(int index) {
        return this.list.listIterator(index);
    }

    public List<E> subList(int fromIndex, int toIndex) {
        Span span = this.helper.buildSpan("subList", (DistributedObject)this.list);
        span.setTag("fromIndex", (Number)fromIndex);
        span.setTag("toIndex", (Number)toIndex);
        return TracingHelper.decorate(() -> this.list.subList(fromIndex, toIndex), span);
    }

    public Spliterator<E> spliterator() {
        return this.list.spliterator();
    }

    public boolean removeIf(Predicate<? super E> filter) {
        Span span = this.helper.buildSpan("removeIf", (DistributedObject)this.list);
        span.setTag("filter", TracingHelper.nullable(filter));
        return TracingHelper.decorate(() -> this.list.removeIf(filter), span);
    }

    public Stream<E> stream() {
        return this.list.stream();
    }

    public Stream<E> parallelStream() {
        return this.list.parallelStream();
    }

    public void forEach(Consumer<? super E> action) {
        Span span = this.helper.buildSpan("forEach", (DistributedObject)this.list);
        span.setTag("action", TracingHelper.nullableClass(action));
        TracingHelper.decorateAction(() -> this.list.forEach(action), span);
    }

    public String getName() {
        return this.list.getName();
    }

    public String addItemListener(ItemListener<E> listener, boolean includeValue) {
        Span span = this.helper.buildSpan("addItemListener", (DistributedObject)this.list);
        span.setTag("listener", TracingHelper.nullableClass(listener));
        span.setTag("includeValue", includeValue);
        return TracingHelper.decorate(() -> this.list.addItemListener(listener, includeValue), span);
    }

    public boolean removeItemListener(String registrationId) {
        Span span = this.helper.buildSpan("removeItemListener", (DistributedObject)this.list);
        span.setTag("registrationId", registrationId);
        return TracingHelper.decorate(() -> this.list.removeItemListener(registrationId), span);
    }

    public String getPartitionKey() {
        return this.list.getPartitionKey();
    }

    public String getServiceName() {
        return this.list.getServiceName();
    }

    public void destroy() {
        Span span = this.helper.buildSpan("destroy", (DistributedObject)this.list);
        TracingHelper.decorateAction(() -> this.list.destroy(), span);
    }
}

