/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.hazelcast;

import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.ICondition;
import com.hazelcast.core.ILock;
import io.opentracing.Span;
import io.opentracing.contrib.hazelcast.TracingCondition;
import io.opentracing.contrib.hazelcast.TracingHelper;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;

public class TracingLock
implements ILock {
    private final ILock lock;
    private final TracingHelper helper;
    private final boolean traceWithActiveSpanOnly;

    public TracingLock(ILock lock, boolean traceWithActiveSpanOnly) {
        this.lock = lock;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.helper = new TracingHelper(traceWithActiveSpanOnly);
    }

    @Deprecated
    public Object getKey() {
        Span span = this.helper.buildSpan("getKey", (DistributedObject)this.lock);
        return TracingHelper.decorate(() -> ((ILock)this.lock).getKey(), span);
    }

    public void lock() {
        Span span = this.helper.buildSpan("lock", (DistributedObject)this.lock);
        TracingHelper.decorateAction(() -> ((ILock)this.lock).lock(), span);
    }

    public boolean tryLock() {
        Span span = this.helper.buildSpan("tryLock", (DistributedObject)this.lock);
        return TracingHelper.decorate(() -> ((ILock)this.lock).tryLock(), span);
    }

    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        Span span = this.helper.buildSpan("tryLock", (DistributedObject)this.lock);
        span.setTag("time", (Number)time);
        span.setTag("unit", TracingHelper.nullable((Object)unit));
        return TracingHelper.decorateExceptionally(() -> this.lock.tryLock(time, unit), span);
    }

    public boolean tryLock(long time, TimeUnit unit, long leaseTime, TimeUnit leaseUnit) throws InterruptedException {
        Span span = this.helper.buildSpan("tryLock", (DistributedObject)this.lock);
        span.setTag("time", (Number)time);
        span.setTag("unit", TracingHelper.nullable((Object)unit));
        span.setTag("leaseTime", (Number)leaseTime);
        span.setTag("leaseUnit", TracingHelper.nullable((Object)leaseUnit));
        return TracingHelper.decorateExceptionally(() -> this.lock.tryLock(time, unit, leaseTime, leaseUnit), span);
    }

    public void unlock() {
        Span span = this.helper.buildSpan("unlock", (DistributedObject)this.lock);
        TracingHelper.decorateAction(() -> ((ILock)this.lock).unlock(), span);
    }

    public void lock(long leaseTime, TimeUnit timeUnit) {
        Span span = this.helper.buildSpan("lock", (DistributedObject)this.lock);
        span.setTag("leaseTime", (Number)leaseTime);
        span.setTag("timeUnit", TracingHelper.nullable((Object)timeUnit));
        TracingHelper.decorateAction(() -> this.lock.lock(leaseTime, timeUnit), span);
    }

    public void forceUnlock() {
        Span span = this.helper.buildSpan("forceUnlock", (DistributedObject)this.lock);
        TracingHelper.decorateAction(() -> ((ILock)this.lock).forceUnlock(), span);
    }

    public Condition newCondition() {
        return this.lock.newCondition();
    }

    public ICondition newCondition(String name) {
        Span span = this.helper.buildSpan("newCondition", (DistributedObject)this.lock);
        span.setTag("conditionName", name);
        return TracingHelper.decorate(() -> new TracingCondition(this.lock.newCondition(name), name, this.traceWithActiveSpanOnly, TracingHelper.inject(span)), span);
    }

    public boolean isLocked() {
        Span span = this.helper.buildSpan("isLocked", (DistributedObject)this.lock);
        return TracingHelper.decorate(() -> ((ILock)this.lock).isLocked(), span);
    }

    public boolean isLockedByCurrentThread() {
        Span span = this.helper.buildSpan("isLockedByCurrentThread", (DistributedObject)this.lock);
        return TracingHelper.decorate(() -> ((ILock)this.lock).isLockedByCurrentThread(), span);
    }

    public int getLockCount() {
        Span span = this.helper.buildSpan("getLockCount", (DistributedObject)this.lock);
        return TracingHelper.decorate(() -> ((ILock)this.lock).getLockCount(), span);
    }

    public long getRemainingLeaseTime() {
        Span span = this.helper.buildSpan("getRemainingLeaseTime", (DistributedObject)this.lock);
        return TracingHelper.decorate(() -> ((ILock)this.lock).getRemainingLeaseTime(), span);
    }

    public void lockInterruptibly() throws InterruptedException {
        Span span = this.helper.buildSpan("lockInterruptibly", (DistributedObject)this.lock);
        TracingHelper.decorateActionExceptionally(() -> this.lock.lockInterruptibly(), span);
    }

    public String getPartitionKey() {
        return this.lock.getPartitionKey();
    }

    public String getName() {
        return this.lock.getName();
    }

    public String getServiceName() {
        return this.lock.getServiceName();
    }

    public void destroy() {
        Span span = this.helper.buildSpan("destroy", (DistributedObject)this.lock);
        TracingHelper.decorateAction(() -> ((ILock)this.lock).destroy(), span);
    }
}

