/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.hazelcast;

import com.hazelcast.aggregation.Aggregator;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.EntryView;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.IMap;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.MapInterceptor;
import com.hazelcast.map.QueryCache;
import com.hazelcast.map.listener.MapListener;
import com.hazelcast.map.listener.MapPartitionLostListener;
import com.hazelcast.mapreduce.JobTracker;
import com.hazelcast.mapreduce.aggregation.Aggregation;
import com.hazelcast.mapreduce.aggregation.Supplier;
import com.hazelcast.monitor.LocalMapStats;
import com.hazelcast.projection.Projection;
import com.hazelcast.query.Predicate;
import com.hazelcast.spi.annotation.Beta;
import io.opentracing.Span;
import io.opentracing.contrib.hazelcast.TracingCompletableFuture;
import io.opentracing.contrib.hazelcast.TracingEntryProcessor;
import io.opentracing.contrib.hazelcast.TracingExecutionCallback;
import io.opentracing.contrib.hazelcast.TracingHelper;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public class TracingMap<K, V>
implements IMap<K, V> {
    private final IMap<K, V> map;
    private final TracingHelper helper;
    private final boolean traceWithActiveSpanOnly;

    public TracingMap(IMap<K, V> map, boolean traceWithActiveSpanOnly) {
        this.map = map;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.helper = new TracingHelper(traceWithActiveSpanOnly);
    }

    public void putAll(Map<? extends K, ? extends V> m) {
        Span span = this.helper.buildSpan("putAll", (DistributedObject)this.map);
        span.setTag("mappings", TracingHelper.mapToString(m));
        TracingHelper.decorateAction(() -> this.map.putAll(m), span);
    }

    public boolean containsKey(Object key) {
        Span span = this.helper.buildSpan("containsKey", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        return TracingHelper.decorate(() -> this.map.containsKey(key), span);
    }

    public boolean containsValue(Object value) {
        Span span = this.helper.buildSpan("containsValue", (DistributedObject)this.map);
        span.setTag("value", TracingHelper.nullable(value));
        return TracingHelper.decorate(() -> this.map.containsValue(value), span);
    }

    public V get(Object key) {
        Span span = this.helper.buildSpan("get", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        return (V)TracingHelper.decorate(() -> this.map.get(key), span);
    }

    public V put(K key, V value) {
        Span span = this.helper.buildSpan("put", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        return (V)TracingHelper.decorate(() -> this.map.put(key, value), span);
    }

    public V remove(Object key) {
        Span span = this.helper.buildSpan("remove", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        return (V)TracingHelper.decorate(() -> this.map.remove(key), span);
    }

    public boolean remove(Object key, Object value) {
        Span span = this.helper.buildSpan("remove", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        return TracingHelper.decorate(() -> this.map.remove(key, value), span);
    }

    public void removeAll(Predicate<K, V> predicate) {
        Span span = this.helper.buildSpan("removeAll", (DistributedObject)this.map);
        span.setTag("predicate", TracingHelper.nullable(predicate));
        TracingHelper.decorateAction(() -> this.map.removeAll(predicate), span);
    }

    public void delete(Object key) {
        Span span = this.helper.buildSpan("delete", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        TracingHelper.decorateAction(() -> this.map.delete(key), span);
    }

    public void flush() {
        Span span = this.helper.buildSpan("flush", (DistributedObject)this.map);
        TracingHelper.decorateAction(() -> this.map.flush(), span);
    }

    public Map<K, V> getAll(Set<K> keys) {
        Span span = this.helper.buildSpan("getAll", (DistributedObject)this.map);
        span.setTag("keys", keys.stream().map(Object::toString).collect(Collectors.joining(", ")));
        return TracingHelper.decorate(() -> this.map.getAll(keys), span);
    }

    public void loadAll(boolean replaceExistingValues) {
        Span span = this.helper.buildSpan("loadAll", (DistributedObject)this.map);
        span.setTag("replaceExistingValues", replaceExistingValues);
        TracingHelper.decorateAction(() -> this.map.loadAll(replaceExistingValues), span);
    }

    public void loadAll(Set<K> keys, boolean replaceExistingValues) {
        Span span = this.helper.buildSpan("loadAll", (DistributedObject)this.map);
        span.setTag("keys", keys.stream().map(Object::toString).collect(Collectors.joining(", ")));
        span.setTag("replaceExistingValues", replaceExistingValues);
        TracingHelper.decorateAction(() -> this.map.loadAll(keys, replaceExistingValues), span);
    }

    public void clear() {
        Span span = this.helper.buildSpan("clear", (DistributedObject)this.map);
        TracingHelper.decorateAction(() -> this.map.clear(), span);
    }

    public ICompletableFuture<V> getAsync(K key) {
        Span span = this.helper.buildSpan("getAsync", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        return TracingHelper.decorate(() -> new TracingCompletableFuture(this.map.getAsync(key), this.traceWithActiveSpanOnly, TracingHelper.inject(span)), span);
    }

    public ICompletableFuture<V> putAsync(K key, V value) {
        Span span = this.helper.buildSpan("putAsync", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        return TracingHelper.decorate(() -> new TracingCompletableFuture(this.map.putAsync(key, value), this.traceWithActiveSpanOnly, TracingHelper.inject(span)), span);
    }

    public ICompletableFuture<V> putAsync(K key, V value, long ttl, TimeUnit timeUnit) {
        Span span = this.helper.buildSpan("putAsync", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        span.setTag("ttl", (Number)ttl);
        span.setTag("timeUnit", TracingHelper.nullable((Object)timeUnit));
        return TracingHelper.decorate(() -> new TracingCompletableFuture(this.map.putAsync(key, value, ttl, timeUnit), this.traceWithActiveSpanOnly, TracingHelper.inject(span)), span);
    }

    public ICompletableFuture<V> putAsync(K key, V value, long ttl, TimeUnit ttlUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Span span = this.helper.buildSpan("putAsync", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        span.setTag("ttl", (Number)ttl);
        span.setTag("maxIdle", (Number)maxIdle);
        span.setTag("ttlUnit", TracingHelper.nullable((Object)ttlUnit));
        span.setTag("maxIdleUnit", TracingHelper.nullable((Object)maxIdleUnit));
        return TracingHelper.decorate(() -> new TracingCompletableFuture(this.map.putAsync(key, value, ttl, ttlUnit, maxIdle, maxIdleUnit), this.traceWithActiveSpanOnly, TracingHelper.inject(span)), span);
    }

    public ICompletableFuture<Void> setAsync(K key, V value) {
        Span span = this.helper.buildSpan("setAsync", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        return TracingHelper.decorate(() -> new TracingCompletableFuture(this.map.setAsync(key, value), this.traceWithActiveSpanOnly, TracingHelper.inject(span)), span);
    }

    public ICompletableFuture<Void> setAsync(K key, V value, long ttl, TimeUnit timeUnit) {
        Span span = this.helper.buildSpan("setAsync", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        span.setTag("ttl", (Number)ttl);
        span.setTag("timeUnit", TracingHelper.nullable((Object)timeUnit));
        return TracingHelper.decorate(() -> new TracingCompletableFuture(this.map.setAsync(key, value, ttl, timeUnit), this.traceWithActiveSpanOnly, TracingHelper.inject(span)), span);
    }

    public ICompletableFuture<Void> setAsync(K key, V value, long ttl, TimeUnit ttlUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Span span = this.helper.buildSpan("setAsync", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        span.setTag("ttl", (Number)ttl);
        span.setTag("maxIdle", (Number)maxIdle);
        span.setTag("ttlUnit", TracingHelper.nullable((Object)ttlUnit));
        span.setTag("maxIdleUnit", TracingHelper.nullable((Object)maxIdleUnit));
        return TracingHelper.decorate(() -> new TracingCompletableFuture(this.map.setAsync(key, value, ttl, ttlUnit, maxIdle, maxIdleUnit), this.traceWithActiveSpanOnly, TracingHelper.inject(span)), span);
    }

    public ICompletableFuture<V> removeAsync(K key) {
        Span span = this.helper.buildSpan("removeAsync", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        return TracingHelper.decorate(() -> new TracingCompletableFuture(this.map.removeAsync(key), this.traceWithActiveSpanOnly, TracingHelper.inject(span)), span);
    }

    public boolean tryRemove(K key, long timeout, TimeUnit timeUnit) {
        Span span = this.helper.buildSpan("tryRemove", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("timeout", (Number)timeout);
        span.setTag("timeUnit", TracingHelper.nullable((Object)timeUnit));
        return TracingHelper.decorate(() -> this.map.tryRemove(key, timeout, timeUnit), span);
    }

    public boolean tryPut(K key, V value, long timeout, TimeUnit timeUnit) {
        Span span = this.helper.buildSpan("tryPut", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        span.setTag("timeout", (Number)timeout);
        span.setTag("timeUnit", TracingHelper.nullable((Object)timeUnit));
        return TracingHelper.decorate(() -> this.map.tryPut(key, value, timeout, timeUnit), span);
    }

    public V put(K key, V value, long ttl, TimeUnit timeUnit) {
        Span span = this.helper.buildSpan("put", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        span.setTag("ttl", (Number)ttl);
        span.setTag("timeUnit", TracingHelper.nullable((Object)timeUnit));
        return (V)TracingHelper.decorate(() -> this.map.put(key, value, ttl, timeUnit), span);
    }

    public V put(K key, V value, long ttl, TimeUnit ttlUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Span span = this.helper.buildSpan("put", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        span.setTag("ttl", (Number)ttl);
        span.setTag("maxIdle", (Number)maxIdle);
        span.setTag("ttlUnit", TracingHelper.nullable((Object)ttlUnit));
        span.setTag("maxIdleUnit", TracingHelper.nullable((Object)maxIdleUnit));
        return (V)TracingHelper.decorate(() -> this.map.put(key, value, ttl, ttlUnit, maxIdle, maxIdleUnit), span);
    }

    public void putTransient(K key, V value, long ttl, TimeUnit timeUnit) {
        Span span = this.helper.buildSpan("putTransient", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        span.setTag("ttl", (Number)ttl);
        span.setTag("timeUnit", TracingHelper.nullable((Object)timeUnit));
        TracingHelper.decorateAction(() -> this.map.putTransient(key, value, ttl, timeUnit), span);
    }

    public void putTransient(K key, V value, long ttl, TimeUnit ttlUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Span span = this.helper.buildSpan("putTransient", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        span.setTag("ttl", (Number)ttl);
        span.setTag("maxIdle", (Number)maxIdle);
        span.setTag("ttlUnit", TracingHelper.nullable((Object)ttlUnit));
        span.setTag("maxIdleUnit", TracingHelper.nullable((Object)maxIdleUnit));
        TracingHelper.decorateAction(() -> this.map.putTransient(key, value, ttl, ttlUnit, maxIdle, maxIdleUnit), span);
    }

    public V putIfAbsent(K key, V value) {
        Span span = this.helper.buildSpan("putIfAbsent", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        return (V)TracingHelper.decorate(() -> this.map.putIfAbsent(key, value), span);
    }

    public V putIfAbsent(K key, V value, long ttl, TimeUnit timeUnit) {
        Span span = this.helper.buildSpan("putIfAbsent", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        span.setTag("ttl", (Number)ttl);
        span.setTag("timeUnit", TracingHelper.nullable((Object)timeUnit));
        return (V)TracingHelper.decorate(() -> this.map.putIfAbsent(key, value, ttl, timeUnit), span);
    }

    public V putIfAbsent(K key, V value, long ttl, TimeUnit ttlUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Span span = this.helper.buildSpan("putIfAbsent", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        span.setTag("ttl", (Number)ttl);
        span.setTag("ttlUnit", TracingHelper.nullable((Object)ttlUnit));
        span.setTag("maxIdle", (Number)maxIdle);
        span.setTag("maxIdleUnit", TracingHelper.nullable((Object)maxIdleUnit));
        return (V)TracingHelper.decorate(() -> this.map.putIfAbsent(key, value, ttl, ttlUnit, maxIdle, maxIdleUnit), span);
    }

    public boolean replace(K key, V oldValue, V newValue) {
        Span span = this.helper.buildSpan("replace", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("oldValue", TracingHelper.nullable(oldValue));
        span.setTag("newValue", TracingHelper.nullable(newValue));
        return TracingHelper.decorate(() -> this.map.replace(key, oldValue, newValue), span);
    }

    public V replace(K key, V value) {
        Span span = this.helper.buildSpan("replace", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        return (V)TracingHelper.decorate(() -> this.map.replace(key, value), span);
    }

    public void set(K key, V value) {
        Span span = this.helper.buildSpan("set", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        TracingHelper.decorateAction(() -> this.map.set(key, value), span);
    }

    public void set(K key, V value, long ttl, TimeUnit timeUnit) {
        Span span = this.helper.buildSpan("set", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        span.setTag("ttl", (Number)ttl);
        span.setTag("timeUnit", TracingHelper.nullable((Object)timeUnit));
        TracingHelper.decorateAction(() -> this.map.set(key, value, ttl, timeUnit), span);
    }

    public void set(K key, V value, long ttl, TimeUnit ttlUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Span span = this.helper.buildSpan("set", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        span.setTag("ttl", (Number)ttl);
        span.setTag("ttlUnit", TracingHelper.nullable((Object)ttlUnit));
        span.setTag("maxIdle", (Number)maxIdle);
        span.setTag("maxIdleUnit", TracingHelper.nullable((Object)maxIdleUnit));
        TracingHelper.decorateAction(() -> this.map.set(key, value, ttl, ttlUnit, maxIdle, maxIdleUnit), span);
    }

    public void lock(K key) {
        Span span = this.helper.buildSpan("lock", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        TracingHelper.decorateAction(() -> this.map.lock(key), span);
    }

    public void lock(K key, long leaseTime, TimeUnit timeUnit) {
        Span span = this.helper.buildSpan("lock", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("leaseTime", TracingHelper.nullable(leaseTime));
        span.setTag("timeUnit", TracingHelper.nullable((Object)timeUnit));
        TracingHelper.decorateAction(() -> this.map.lock(key, leaseTime, timeUnit), span);
    }

    public boolean isLocked(K key) {
        Span span = this.helper.buildSpan("isLocked", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        return TracingHelper.decorate(() -> this.map.isLocked(key), span);
    }

    public boolean tryLock(K key) {
        Span span = this.helper.buildSpan("tryLock", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        return TracingHelper.decorate(() -> this.map.tryLock(key), span);
    }

    public boolean tryLock(K key, long time, TimeUnit timeUnit) throws InterruptedException {
        Span span = this.helper.buildSpan("tryLock", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("time", TracingHelper.nullable(time));
        span.setTag("timeUnit", TracingHelper.nullable((Object)timeUnit));
        return TracingHelper.decorateExceptionally(() -> this.map.tryLock(key, time, timeUnit), span);
    }

    public boolean tryLock(K key, long time, TimeUnit timeUnit, long leaseTime, TimeUnit leaseTimeUnit) throws InterruptedException {
        Span span = this.helper.buildSpan("tryLock", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("time", TracingHelper.nullable(time));
        span.setTag("timeUnit", TracingHelper.nullable((Object)timeUnit));
        span.setTag("leaseTime", TracingHelper.nullable(leaseTime));
        span.setTag("leaseTimeUnit", TracingHelper.nullable((Object)leaseTimeUnit));
        return TracingHelper.decorateExceptionally(() -> this.map.tryLock(key, time, timeUnit, leaseTime, leaseTimeUnit), span);
    }

    public void unlock(K key) {
        Span span = this.helper.buildSpan("unlock", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        TracingHelper.decorateAction(() -> this.map.unlock(key), span);
    }

    public void forceUnlock(K key) {
        Span span = this.helper.buildSpan("forceUnlock", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        TracingHelper.decorateAction(() -> this.map.forceUnlock(key), span);
    }

    public String addLocalEntryListener(MapListener listener) {
        Span span = this.helper.buildSpan("addLocalEntryListener", (DistributedObject)this.map);
        span.setTag("listener", TracingHelper.nullableClass(listener));
        return TracingHelper.decorate(() -> this.map.addLocalEntryListener(listener), span);
    }

    @Deprecated
    public String addLocalEntryListener(EntryListener listener) {
        Span span = this.helper.buildSpan("addLocalEntryListener", (DistributedObject)this.map);
        span.setTag("listener", TracingHelper.nullableClass(listener));
        return TracingHelper.decorate(() -> this.map.addLocalEntryListener(listener), span);
    }

    public String addLocalEntryListener(MapListener listener, Predicate<K, V> predicate, boolean includeValue) {
        Span span = this.helper.buildSpan("addLocalEntryListener", (DistributedObject)this.map);
        span.setTag("listener", TracingHelper.nullableClass(listener));
        span.setTag("predicate", TracingHelper.nullable(predicate));
        span.setTag("includeValue", includeValue);
        return TracingHelper.decorate(() -> this.map.addLocalEntryListener(listener, predicate, includeValue), span);
    }

    @Deprecated
    public String addLocalEntryListener(EntryListener listener, Predicate<K, V> predicate, boolean includeValue) {
        Span span = this.helper.buildSpan("addLocalEntryListener", (DistributedObject)this.map);
        span.setTag("listener", TracingHelper.nullableClass(listener));
        span.setTag("predicate", TracingHelper.nullable(predicate));
        span.setTag("includeValue", includeValue);
        return TracingHelper.decorate(() -> this.map.addLocalEntryListener(listener, predicate, includeValue), span);
    }

    public String addLocalEntryListener(MapListener listener, Predicate<K, V> predicate, K key, boolean includeValue) {
        Span span = this.helper.buildSpan("addLocalEntryListener", (DistributedObject)this.map);
        span.setTag("listener", TracingHelper.nullableClass(listener));
        span.setTag("predicate", TracingHelper.nullable(predicate));
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("includeValue", includeValue);
        return TracingHelper.decorate(() -> this.map.addLocalEntryListener(listener, predicate, key, includeValue), span);
    }

    @Deprecated
    public String addLocalEntryListener(EntryListener listener, Predicate<K, V> predicate, K key, boolean includeValue) {
        Span span = this.helper.buildSpan("addLocalEntryListener", (DistributedObject)this.map);
        span.setTag("listener", TracingHelper.nullableClass(listener));
        span.setTag("predicate", TracingHelper.nullable(predicate));
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("includeValue", includeValue);
        return TracingHelper.decorate(() -> this.map.addLocalEntryListener(listener, predicate, key, includeValue), span);
    }

    public String addInterceptor(MapInterceptor interceptor) {
        Span span = this.helper.buildSpan("addInterceptor", (DistributedObject)this.map);
        span.setTag("interceptor", TracingHelper.nullableClass(interceptor));
        return TracingHelper.decorate(() -> this.map.addInterceptor(interceptor), span);
    }

    public void removeInterceptor(String id) {
        Span span = this.helper.buildSpan("removeInterceptor", (DistributedObject)this.map);
        span.setTag("id", TracingHelper.nullable(id));
        TracingHelper.decorateAction(() -> this.map.removeInterceptor(id), span);
    }

    public String addEntryListener(MapListener listener, boolean includeValue) {
        Span span = this.helper.buildSpan("addEntryListener", (DistributedObject)this.map);
        span.setTag("listener", TracingHelper.nullableClass(listener));
        span.setTag("includeValue", includeValue);
        return TracingHelper.decorate(() -> this.map.addEntryListener(listener, includeValue), span);
    }

    @Deprecated
    public String addEntryListener(EntryListener listener, boolean includeValue) {
        Span span = this.helper.buildSpan("addEntryListener", (DistributedObject)this.map);
        span.setTag("listener", TracingHelper.nullableClass(listener));
        span.setTag("includeValue", includeValue);
        return TracingHelper.decorate(() -> this.map.addEntryListener(listener, includeValue), span);
    }

    public boolean removeEntryListener(String id) {
        Span span = this.helper.buildSpan("removeEntryListener", (DistributedObject)this.map);
        span.setTag("id", TracingHelper.nullable(id));
        return TracingHelper.decorate(() -> this.map.removeEntryListener(id), span);
    }

    public String addPartitionLostListener(MapPartitionLostListener listener) {
        Span span = this.helper.buildSpan("addPartitionLostListener", (DistributedObject)this.map);
        span.setTag("listener", TracingHelper.nullableClass(listener));
        return TracingHelper.decorate(() -> this.map.addPartitionLostListener(listener), span);
    }

    public boolean removePartitionLostListener(String id) {
        Span span = this.helper.buildSpan("removePartitionLostListener", (DistributedObject)this.map);
        span.setTag("id", TracingHelper.nullable(id));
        return TracingHelper.decorate(() -> this.map.removePartitionLostListener(id), span);
    }

    public String addEntryListener(MapListener listener, K key, boolean includeValue) {
        Span span = this.helper.buildSpan("addEntryListener", (DistributedObject)this.map);
        span.setTag("listener", TracingHelper.nullableClass(listener));
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("includeValue", includeValue);
        return TracingHelper.decorate(() -> this.map.addEntryListener(listener, key, includeValue), span);
    }

    @Deprecated
    public String addEntryListener(EntryListener listener, K key, boolean includeValue) {
        Span span = this.helper.buildSpan("addEntryListener", (DistributedObject)this.map);
        span.setTag("listener", TracingHelper.nullableClass(listener));
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("includeValue", includeValue);
        return TracingHelper.decorate(() -> this.map.addEntryListener(listener, key, includeValue), span);
    }

    public String addEntryListener(MapListener listener, Predicate<K, V> predicate, boolean includeValue) {
        Span span = this.helper.buildSpan("addEntryListener", (DistributedObject)this.map);
        span.setTag("listener", TracingHelper.nullableClass(listener));
        span.setTag("predicate", TracingHelper.nullable(predicate));
        span.setTag("includeValue", includeValue);
        return TracingHelper.decorate(() -> this.map.addEntryListener(listener, predicate, includeValue), span);
    }

    @Deprecated
    public String addEntryListener(EntryListener listener, Predicate<K, V> predicate, boolean includeValue) {
        Span span = this.helper.buildSpan("addEntryListener", (DistributedObject)this.map);
        span.setTag("listener", TracingHelper.nullableClass(listener));
        span.setTag("predicate", TracingHelper.nullable(predicate));
        span.setTag("includeValue", includeValue);
        return TracingHelper.decorate(() -> this.map.addEntryListener(listener, predicate, includeValue), span);
    }

    public String addEntryListener(MapListener listener, Predicate<K, V> predicate, K key, boolean includeValue) {
        Span span = this.helper.buildSpan("addEntryListener", (DistributedObject)this.map);
        span.setTag("listener", TracingHelper.nullableClass(listener));
        span.setTag("predicate", TracingHelper.nullable(predicate));
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("includeValue", includeValue);
        return TracingHelper.decorate(() -> this.map.addEntryListener(listener, predicate, key, includeValue), span);
    }

    @Deprecated
    public String addEntryListener(EntryListener listener, Predicate<K, V> predicate, K key, boolean includeValue) {
        Span span = this.helper.buildSpan("addEntryListener", (DistributedObject)this.map);
        span.setTag("listener", TracingHelper.nullableClass(listener));
        span.setTag("predicate", TracingHelper.nullable(predicate));
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("includeValue", includeValue);
        return TracingHelper.decorate(() -> this.map.addEntryListener(listener, predicate, key, includeValue), span);
    }

    public EntryView<K, V> getEntryView(K key) {
        Span span = this.helper.buildSpan("getEntryView", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        return TracingHelper.decorate(() -> this.map.getEntryView(key), span);
    }

    public boolean evict(K key) {
        Span span = this.helper.buildSpan("evict", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        return TracingHelper.decorate(() -> this.map.evict(key), span);
    }

    public void evictAll() {
        Span span = this.helper.buildSpan("evictAll", (DistributedObject)this.map);
        TracingHelper.decorateAction(() -> this.map.evictAll(), span);
    }

    public Set<K> keySet() {
        Span span = this.helper.buildSpan("keySet", (DistributedObject)this.map);
        return TracingHelper.decorate(() -> this.map.keySet(), span);
    }

    public Collection<V> values() {
        Span span = this.helper.buildSpan("values", (DistributedObject)this.map);
        return TracingHelper.decorate(() -> this.map.values(), span);
    }

    public Set<Map.Entry<K, V>> entrySet() {
        Span span = this.helper.buildSpan("entrySet", (DistributedObject)this.map);
        return TracingHelper.decorate(() -> this.map.entrySet(), span);
    }

    public Set<K> keySet(Predicate predicate) {
        Span span = this.helper.buildSpan("keySet", (DistributedObject)this.map);
        span.setTag("predicate", TracingHelper.nullable(predicate));
        return TracingHelper.decorate(() -> this.map.keySet(predicate), span);
    }

    public Set<Map.Entry<K, V>> entrySet(Predicate predicate) {
        Span span = this.helper.buildSpan("entrySet", (DistributedObject)this.map);
        span.setTag("predicate", TracingHelper.nullable(predicate));
        return TracingHelper.decorate(() -> this.map.entrySet(predicate), span);
    }

    public Collection<V> values(Predicate predicate) {
        Span span = this.helper.buildSpan("values", (DistributedObject)this.map);
        span.setTag("predicate", TracingHelper.nullable(predicate));
        return TracingHelper.decorate(() -> this.map.values(predicate), span);
    }

    public Set<K> localKeySet() {
        Span span = this.helper.buildSpan("localKeySet", (DistributedObject)this.map);
        return TracingHelper.decorate(() -> this.map.localKeySet(), span);
    }

    public Set<K> localKeySet(Predicate predicate) {
        Span span = this.helper.buildSpan("localKeySet", (DistributedObject)this.map);
        span.setTag("predicate", TracingHelper.nullable(predicate));
        return TracingHelper.decorate(() -> this.map.localKeySet(predicate), span);
    }

    public void addIndex(String attribute, boolean ordered) {
        Span span = this.helper.buildSpan("addIndex", (DistributedObject)this.map);
        span.setTag("attribute", TracingHelper.nullable(attribute));
        span.setTag("ordered", ordered);
        TracingHelper.decorateAction(() -> this.map.addIndex(attribute, ordered), span);
    }

    public LocalMapStats getLocalMapStats() {
        Span span = this.helper.buildSpan("getLocalMapStats", (DistributedObject)this.map);
        return TracingHelper.decorate(() -> this.map.getLocalMapStats(), span);
    }

    public Object executeOnKey(K key, EntryProcessor entryProcessor) {
        Span span = this.helper.buildSpan("executeOnKey", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("entryProcessor", TracingHelper.nullableClass(entryProcessor));
        Map<String, String> spanContextMap = TracingHelper.inject(span);
        return TracingHelper.decorate(() -> this.map.executeOnKey(key, new TracingEntryProcessor(entryProcessor, this.traceWithActiveSpanOnly, spanContextMap)), span);
    }

    public Map<K, Object> executeOnKeys(Set<K> keys, EntryProcessor entryProcessor) {
        Span span = this.helper.buildSpan("executeOnKeys", (DistributedObject)this.map);
        span.setTag("keys", keys.stream().map(TracingHelper::nullable).collect(Collectors.joining(", ")));
        span.setTag("entryProcessor", TracingHelper.nullableClass(entryProcessor));
        return TracingHelper.decorate(() -> this.map.executeOnKeys(keys, new TracingEntryProcessor(entryProcessor, this.traceWithActiveSpanOnly, TracingHelper.inject(span))), span);
    }

    public void submitToKey(K key, EntryProcessor entryProcessor, ExecutionCallback callback) {
        Span span = this.helper.buildSpan("submitToKey", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("entryProcessor", TracingHelper.nullableClass(entryProcessor));
        Map<String, String> spanContextMap = TracingHelper.inject(span);
        TracingHelper.decorateAction(() -> this.map.submitToKey(key, new TracingEntryProcessor(entryProcessor, this.traceWithActiveSpanOnly, spanContextMap), new TracingExecutionCallback(callback, this.traceWithActiveSpanOnly, spanContextMap)), span);
    }

    public ICompletableFuture submitToKey(K key, EntryProcessor entryProcessor) {
        Span span = this.helper.buildSpan("submitToKey", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("entryProcessor", TracingHelper.nullableClass(entryProcessor));
        return TracingHelper.decorate(() -> this.map.submitToKey(key, new TracingEntryProcessor(entryProcessor, this.traceWithActiveSpanOnly, TracingHelper.inject(span))), span);
    }

    public Map<K, Object> executeOnEntries(EntryProcessor entryProcessor) {
        Span span = this.helper.buildSpan("executeOnEntries", (DistributedObject)this.map);
        span.setTag("entryProcessor", TracingHelper.nullableClass(entryProcessor));
        return TracingHelper.decorate(() -> this.map.executeOnEntries(new TracingEntryProcessor(entryProcessor, this.traceWithActiveSpanOnly, TracingHelper.inject(span))), span);
    }

    public Map<K, Object> executeOnEntries(EntryProcessor entryProcessor, Predicate predicate) {
        Span span = this.helper.buildSpan("executeOnEntries", (DistributedObject)this.map);
        span.setTag("entryProcessor", TracingHelper.nullableClass(entryProcessor));
        span.setTag("predicate", TracingHelper.nullable(predicate));
        return TracingHelper.decorate(() -> this.map.executeOnEntries(new TracingEntryProcessor(entryProcessor, this.traceWithActiveSpanOnly, TracingHelper.inject(span)), predicate), span);
    }

    public <R> R aggregate(Aggregator<Map.Entry<K, V>, R> aggregator) {
        Span span = this.helper.buildSpan("aggregate", (DistributedObject)this.map);
        span.setTag("aggregator", TracingHelper.nullableClass(aggregator));
        return (R)TracingHelper.decorate(() -> this.map.aggregate(aggregator), span);
    }

    public <R> R aggregate(Aggregator<Map.Entry<K, V>, R> aggregator, Predicate<K, V> predicate) {
        Span span = this.helper.buildSpan("aggregate", (DistributedObject)this.map);
        span.setTag("aggregator", TracingHelper.nullableClass(aggregator));
        span.setTag("predicate", TracingHelper.nullable(predicate));
        return (R)TracingHelper.decorate(() -> this.map.aggregate(aggregator, predicate), span);
    }

    public <R> Collection<R> project(Projection<Map.Entry<K, V>, R> projection) {
        Span span = this.helper.buildSpan("project", (DistributedObject)this.map);
        span.setTag("projection", TracingHelper.nullableClass(projection));
        return TracingHelper.decorate(() -> this.map.project(projection), span);
    }

    public <R> Collection<R> project(Projection<Map.Entry<K, V>, R> projection, Predicate<K, V> predicate) {
        Span span = this.helper.buildSpan("project", (DistributedObject)this.map);
        span.setTag("projection", TracingHelper.nullableClass(projection));
        span.setTag("predicate", TracingHelper.nullable(predicate));
        return TracingHelper.decorate(() -> this.map.project(projection, predicate), span);
    }

    @Deprecated
    public <SuppliedValue, Result> Result aggregate(Supplier<K, V, SuppliedValue> supplier, Aggregation<K, SuppliedValue, Result> aggregation) {
        return (Result)this.map.aggregate(supplier, aggregation);
    }

    @Deprecated
    public <SuppliedValue, Result> Result aggregate(Supplier<K, V, SuppliedValue> supplier, Aggregation<K, SuppliedValue, Result> aggregation, JobTracker jobTracker) {
        return (Result)this.map.aggregate(supplier, aggregation, jobTracker);
    }

    @Beta
    public QueryCache<K, V> getQueryCache(String queryCacheName) {
        Span span = this.helper.buildSpan("getQueryCache", (DistributedObject)this.map);
        span.setTag("queryCacheName", TracingHelper.nullable(queryCacheName));
        return TracingHelper.decorate(() -> this.map.getQueryCache(queryCacheName), span);
    }

    @Beta
    public QueryCache<K, V> getQueryCache(String queryCacheName, Predicate<K, V> predicate, boolean includeValue) {
        Span span = this.helper.buildSpan("getQueryCache", (DistributedObject)this.map);
        span.setTag("queryCacheName", TracingHelper.nullable(queryCacheName));
        span.setTag("predicate", TracingHelper.nullable(predicate));
        span.setTag("includeValue", includeValue);
        return TracingHelper.decorate(() -> this.map.getQueryCache(queryCacheName, predicate, includeValue), span);
    }

    @Beta
    public QueryCache<K, V> getQueryCache(String queryCacheName, MapListener listener, Predicate<K, V> predicate, boolean includeValue) {
        Span span = this.helper.buildSpan("getQueryCache", (DistributedObject)this.map);
        span.setTag("queryCacheName", TracingHelper.nullable(queryCacheName));
        span.setTag("predicate", TracingHelper.nullable(predicate));
        span.setTag("listener", TracingHelper.nullableClass(listener));
        span.setTag("includeValue", includeValue);
        return TracingHelper.decorate(() -> this.map.getQueryCache(queryCacheName, listener, predicate, includeValue), span);
    }

    public boolean setTtl(K key, long ttl, TimeUnit timeunit) {
        Span span = this.helper.buildSpan("setTtl", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("ttl", (Number)ttl);
        span.setTag("timeunit", TracingHelper.nullable((Object)timeunit));
        return TracingHelper.decorate(() -> this.map.setTtl(key, ttl, timeunit), span);
    }

    public V getOrDefault(Object key, V defaultValue) {
        Span span = this.helper.buildSpan("getOrDefault", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("defaultValue", TracingHelper.nullable(defaultValue));
        return (V)TracingHelper.decorate(() -> this.map.getOrDefault(key, defaultValue), span);
    }

    public void forEach(BiConsumer<? super K, ? super V> action) {
        Span span = this.helper.buildSpan("forEach", (DistributedObject)this.map);
        span.setTag("action", TracingHelper.nullableClass(action));
        TracingHelper.decorateAction(() -> this.map.forEach(action), span);
    }

    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        Span span = this.helper.buildSpan("replaceAll", (DistributedObject)this.map);
        span.setTag("function", TracingHelper.nullableClass(function));
        TracingHelper.decorateAction(() -> this.map.replaceAll(function), span);
    }

    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        Span span = this.helper.buildSpan("computeIfAbsent", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("mappingFunction", TracingHelper.nullableClass(mappingFunction));
        return (V)TracingHelper.decorate(() -> this.map.computeIfAbsent(key, mappingFunction), span);
    }

    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Span span = this.helper.buildSpan("computeIfPresent", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("mappingFunction", TracingHelper.nullableClass(remappingFunction));
        return (V)TracingHelper.decorate(() -> this.map.computeIfPresent(key, remappingFunction), span);
    }

    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Span span = this.helper.buildSpan("compute", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("mappingFunction", TracingHelper.nullableClass(remappingFunction));
        return (V)TracingHelper.decorate(() -> this.map.compute(key, remappingFunction), span);
    }

    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        Span span = this.helper.buildSpan("merge", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        span.setTag("mappingFunction", TracingHelper.nullableClass(remappingFunction));
        return (V)TracingHelper.decorate(() -> this.map.merge(key, value, remappingFunction), span);
    }

    public int size() {
        Span span = this.helper.buildSpan("size", (DistributedObject)this.map);
        return TracingHelper.decorate(() -> this.map.size(), span);
    }

    public boolean isEmpty() {
        Span span = this.helper.buildSpan("isEmpty", (DistributedObject)this.map);
        return TracingHelper.decorate(() -> this.map.isEmpty(), span);
    }

    public boolean equals(Object o) {
        return this.map.equals(o);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String getPartitionKey() {
        return this.map.getPartitionKey();
    }

    public String getName() {
        return this.map.getName();
    }

    public String getServiceName() {
        return this.map.getServiceName();
    }

    public void destroy() {
        Span span = this.helper.buildSpan("destroy", (DistributedObject)this.map);
        TracingHelper.decorateAction(() -> this.map.destroy(), span);
    }
}

