/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.hazelcast;

import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.contrib.hazelcast.TracingHelper;
import io.opentracing.contrib.hazelcast.TracingMessage;

public class TracingMessageListener<E>
implements MessageListener<TracingMessage<E>> {
    private final MessageListener<E> listener;
    private final String topic;
    private final boolean traceWithActiveSpanOnly;

    public TracingMessageListener(MessageListener<E> listener, String topic, boolean traceWithActiveSpanOnly) {
        this.listener = listener;
        this.topic = topic;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
    }

    public void onMessage(Message<TracingMessage<E>> message) {
        SpanContext parent = TracingHelper.extract(((TracingMessage)message.getMessageObject()).getSpanContextMap());
        Span span = TracingHelper.buildSpan("onMessage", parent, this.traceWithActiveSpanOnly);
        span.setTag("message", TracingHelper.nullable(((TracingMessage)message.getMessageObject()).getMessage()));
        span.setTag("publishTime", (Number)message.getPublishTime());
        span.setTag("topic", this.topic);
        span.setTag("listener", TracingHelper.nullableClass(this.listener));
        span.setTag("publishingMember", TracingHelper.nullable(message.getPublishingMember().getAddress()));
        TracingHelper.decorateAction(() -> this.listener.onMessage(new Message(this.topic, ((TracingMessage)message.getMessageObject()).getMessage(), message.getPublishTime(), message.getPublishingMember())), span);
    }
}

