/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.hazelcast;

import com.hazelcast.core.Member;
import com.hazelcast.core.MultiExecutionCallback;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.contrib.hazelcast.TracingHelper;
import java.util.Map;

public class TracingMultiExecutionCallback
implements MultiExecutionCallback {
    private final MultiExecutionCallback callback;
    private final boolean traceWithActiveSpanOnly;
    private final Map<String, String> spanContextMap;

    public TracingMultiExecutionCallback(MultiExecutionCallback callback, boolean traceWithActiveSpanOnly, Map<String, String> spanContextMap) {
        this.callback = callback;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.spanContextMap = spanContextMap;
    }

    public void onResponse(Member member, Object value) {
        SpanContext parent = TracingHelper.extract(this.spanContextMap);
        Span span = TracingHelper.buildSpan("onResponse", parent, this.traceWithActiveSpanOnly);
        span.setTag("member", member.getAddress().toString());
        span.setTag("value", TracingHelper.nullable(value));
        span.setTag("callback", TracingHelper.nullableClass(this.callback));
        TracingHelper.decorateAction(() -> this.callback.onResponse(member, value), span);
    }

    public void onComplete(Map<Member, Object> values) {
        SpanContext parent = TracingHelper.extract(this.spanContextMap);
        Span span = TracingHelper.buildSpan("onComplete", parent, this.traceWithActiveSpanOnly);
        span.setTag("callback", TracingHelper.nullableClass(this.callback));
        span.setTag("values", TracingHelper.mapToString(values));
        TracingHelper.decorateAction(() -> this.callback.onComplete(values), span);
    }
}

