/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.hazelcast;

import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.MultiMap;
import com.hazelcast.mapreduce.JobTracker;
import com.hazelcast.mapreduce.aggregation.Aggregation;
import com.hazelcast.mapreduce.aggregation.Supplier;
import com.hazelcast.monitor.LocalMultiMapStats;
import io.opentracing.Span;
import io.opentracing.contrib.hazelcast.TracingHelper;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class TracingMultiMap<K, V>
implements MultiMap<K, V> {
    private final MultiMap<K, V> map;
    private final TracingHelper helper;

    public TracingMultiMap(MultiMap<K, V> map, boolean traceWithActiveSpanOnly) {
        this.map = map;
        this.helper = new TracingHelper(traceWithActiveSpanOnly);
    }

    public String getName() {
        return this.map.getName();
    }

    public boolean put(K key, V value) {
        Span span = this.helper.buildSpan("put", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        return TracingHelper.decorate(() -> this.map.put(key, value), span);
    }

    public Collection<V> get(K key) {
        Span span = this.helper.buildSpan("get", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        return TracingHelper.decorate(() -> this.map.get(key), span);
    }

    public boolean remove(Object key, Object value) {
        Span span = this.helper.buildSpan("remove", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        return TracingHelper.decorate(() -> this.map.remove(key, value), span);
    }

    public Collection<V> remove(Object key) {
        Span span = this.helper.buildSpan("remove", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        return TracingHelper.decorate(() -> this.map.remove(key), span);
    }

    public void delete(Object key) {
        Span span = this.helper.buildSpan("delete", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        TracingHelper.decorateAction(() -> this.map.delete(key), span);
    }

    public Set<K> localKeySet() {
        Span span = this.helper.buildSpan("localKeySet", (DistributedObject)this.map);
        return TracingHelper.decorate(() -> this.map.localKeySet(), span);
    }

    public Set<K> keySet() {
        Span span = this.helper.buildSpan("keySet", (DistributedObject)this.map);
        return TracingHelper.decorate(() -> this.map.keySet(), span);
    }

    public Collection<V> values() {
        Span span = this.helper.buildSpan("values", (DistributedObject)this.map);
        return TracingHelper.decorate(() -> this.map.values(), span);
    }

    public Set<Map.Entry<K, V>> entrySet() {
        Span span = this.helper.buildSpan("entrySet", (DistributedObject)this.map);
        return TracingHelper.decorate(() -> this.map.entrySet(), span);
    }

    public boolean containsKey(K key) {
        Span span = this.helper.buildSpan("containsKey", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        return TracingHelper.decorate(() -> this.map.containsKey(key), span);
    }

    public boolean containsValue(Object value) {
        Span span = this.helper.buildSpan("containsValue", (DistributedObject)this.map);
        span.setTag("value", TracingHelper.nullable(value));
        return TracingHelper.decorate(() -> this.map.containsValue(value), span);
    }

    public boolean containsEntry(K key, V value) {
        Span span = this.helper.buildSpan("containsEntry", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        return TracingHelper.decorate(() -> this.map.containsEntry(key, value), span);
    }

    public int size() {
        Span span = this.helper.buildSpan("size", (DistributedObject)this.map);
        return TracingHelper.decorate(() -> this.map.size(), span);
    }

    public void clear() {
        Span span = this.helper.buildSpan("clear", (DistributedObject)this.map);
        TracingHelper.decorateAction(() -> this.map.clear(), span);
    }

    public int valueCount(K key) {
        Span span = this.helper.buildSpan("valueCount", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        return TracingHelper.decorate(() -> this.map.valueCount(key), span);
    }

    public String addLocalEntryListener(EntryListener<K, V> listener) {
        Span span = this.helper.buildSpan("addLocalEntryListener", (DistributedObject)this.map);
        span.setTag("listener", TracingHelper.nullableClass(listener));
        return TracingHelper.decorate(() -> this.map.addLocalEntryListener(listener), span);
    }

    public String addEntryListener(EntryListener<K, V> listener, boolean includeValue) {
        Span span = this.helper.buildSpan("addEntryListener", (DistributedObject)this.map);
        span.setTag("listener", TracingHelper.nullableClass(listener));
        span.setTag("includeValue", includeValue);
        return TracingHelper.decorate(() -> this.map.addEntryListener(listener, includeValue), span);
    }

    public boolean removeEntryListener(String registrationId) {
        Span span = this.helper.buildSpan("removeEntryListener", (DistributedObject)this.map);
        span.setTag("registrationId", TracingHelper.nullable(registrationId));
        return TracingHelper.decorate(() -> this.map.removeEntryListener(registrationId), span);
    }

    public String addEntryListener(EntryListener<K, V> listener, K key, boolean includeValue) {
        Span span = this.helper.buildSpan("addEntryListener", (DistributedObject)this.map);
        span.setTag("listener", TracingHelper.nullableClass(listener));
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("includeValue", includeValue);
        return TracingHelper.decorate(() -> this.map.addEntryListener(listener, key, includeValue), span);
    }

    public void lock(K key) {
        Span span = this.helper.buildSpan("lock", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        TracingHelper.decorateAction(() -> this.map.lock(key), span);
    }

    public void lock(K key, long leaseTime, TimeUnit timeUnit) {
        Span span = this.helper.buildSpan("lock", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("leaseTime", TracingHelper.nullable(leaseTime));
        span.setTag("timeUnit", TracingHelper.nullable((Object)timeUnit));
        TracingHelper.decorateAction(() -> this.map.lock(key, leaseTime, timeUnit), span);
    }

    public boolean isLocked(K key) {
        Span span = this.helper.buildSpan("isLocked", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        return TracingHelper.decorate(() -> this.map.isLocked(key), span);
    }

    public boolean tryLock(K key) {
        Span span = this.helper.buildSpan("tryLock", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        return TracingHelper.decorate(() -> this.map.tryLock(key), span);
    }

    public boolean tryLock(K key, long time, TimeUnit timeUnit) throws InterruptedException {
        Span span = this.helper.buildSpan("tryLock", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("time", TracingHelper.nullable(time));
        span.setTag("timeUnit", TracingHelper.nullable((Object)timeUnit));
        return TracingHelper.decorateExceptionally(() -> this.map.tryLock(key, time, timeUnit), span);
    }

    public boolean tryLock(K key, long time, TimeUnit timeUnit, long leaseTime, TimeUnit leaseTimeUnit) throws InterruptedException {
        Span span = this.helper.buildSpan("tryLock", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("time", TracingHelper.nullable(time));
        span.setTag("timeUnit", TracingHelper.nullable((Object)timeUnit));
        span.setTag("leaseTime", TracingHelper.nullable(leaseTime));
        span.setTag("leaseTimeUnit", TracingHelper.nullable((Object)leaseTimeUnit));
        return TracingHelper.decorateExceptionally(() -> this.map.tryLock(key, time, timeUnit, leaseTime, leaseTimeUnit), span);
    }

    public void unlock(K key) {
        Span span = this.helper.buildSpan("unlock", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        TracingHelper.decorateAction(() -> this.map.unlock(key), span);
    }

    public void forceUnlock(K key) {
        Span span = this.helper.buildSpan("forceUnlock", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        TracingHelper.decorateAction(() -> this.map.forceUnlock(key), span);
    }

    public LocalMultiMapStats getLocalMultiMapStats() {
        Span span = this.helper.buildSpan("getLocalMultiMapStats", (DistributedObject)this.map);
        return TracingHelper.decorate(() -> this.map.getLocalMultiMapStats(), span);
    }

    @Deprecated
    public <SuppliedValue, Result> Result aggregate(Supplier<K, V, SuppliedValue> supplier, Aggregation<K, SuppliedValue, Result> aggregation) {
        Span span = this.helper.buildSpan("aggregate", (DistributedObject)this.map);
        span.setTag("supplier", TracingHelper.nullableClass(supplier));
        span.setTag("aggregation", TracingHelper.nullableClass(aggregation));
        return (Result)TracingHelper.decorate(() -> this.map.aggregate(supplier, aggregation), span);
    }

    @Deprecated
    public <SuppliedValue, Result> Result aggregate(Supplier<K, V, SuppliedValue> supplier, Aggregation<K, SuppliedValue, Result> aggregation, JobTracker jobTracker) {
        Span span = this.helper.buildSpan("aggregate", (DistributedObject)this.map);
        span.setTag("supplier", TracingHelper.nullableClass(supplier));
        span.setTag("aggregation", TracingHelper.nullableClass(aggregation));
        span.setTag("jobTracker", TracingHelper.nullableClass(jobTracker));
        return (Result)TracingHelper.decorate(() -> this.map.aggregate(supplier, aggregation, jobTracker), span);
    }

    public String getPartitionKey() {
        return this.map.getPartitionKey();
    }

    public String getServiceName() {
        return this.map.getServiceName();
    }

    public void destroy() {
        Span span = this.helper.buildSpan("destroy", (DistributedObject)this.map);
        TracingHelper.decorateAction(() -> this.map.destroy(), span);
    }
}

