/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.hazelcast;

import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ItemListener;
import com.hazelcast.monitor.LocalQueueStats;
import io.opentracing.Span;
import io.opentracing.contrib.hazelcast.TracingHelper;
import java.util.Collection;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TracingQueue<E>
implements IQueue<E> {
    private final IQueue<E> queue;
    private final TracingHelper helper;

    public TracingQueue(IQueue<E> queue, boolean traceWithActiveSpanOnly) {
        this.queue = queue;
        this.helper = new TracingHelper(traceWithActiveSpanOnly);
    }

    public E poll() {
        Span span = this.helper.buildSpan("poll", (DistributedObject)this.queue);
        return (E)TracingHelper.decorate(() -> this.queue.poll(), span);
    }

    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        Span span = this.helper.buildSpan("poll", (DistributedObject)this.queue);
        span.setTag("timeout", (Number)timeout);
        span.setTag("unit", TracingHelper.nullable((Object)unit));
        return (E)TracingHelper.decorateExceptionally(() -> this.queue.poll(timeout, unit), span);
    }

    public E take() throws InterruptedException {
        Span span = this.helper.buildSpan("take", (DistributedObject)this.queue);
        return (E)TracingHelper.decorateExceptionally(() -> this.queue.take(), span);
    }

    public LocalQueueStats getLocalQueueStats() {
        return this.queue.getLocalQueueStats();
    }

    public boolean add(E element) {
        Span span = this.helper.buildSpan("add", (DistributedObject)this.queue);
        span.setTag("element", TracingHelper.nullable(element));
        return TracingHelper.decorate(() -> this.queue.add(element), span);
    }

    public boolean offer(E element) {
        Span span = this.helper.buildSpan("offer", (DistributedObject)this.queue);
        span.setTag("element", TracingHelper.nullable(element));
        return TracingHelper.decorate(() -> this.queue.offer(element), span);
    }

    public void put(E element) throws InterruptedException {
        Span span = this.helper.buildSpan("put", (DistributedObject)this.queue);
        span.setTag("element", TracingHelper.nullable(element));
        TracingHelper.decorateActionExceptionally(() -> this.queue.put(element), span);
    }

    public boolean offer(E element, long timeout, TimeUnit unit) throws InterruptedException {
        Span span = this.helper.buildSpan("offer", (DistributedObject)this.queue);
        span.setTag("element", TracingHelper.nullable(element));
        span.setTag("timeout", (Number)timeout);
        span.setTag("unit", TracingHelper.nullable((Object)unit));
        return TracingHelper.decorateExceptionally(() -> this.queue.offer(element, timeout, unit), span);
    }

    public int remainingCapacity() {
        Span span = this.helper.buildSpan("remainingCapacity", (DistributedObject)this.queue);
        return TracingHelper.decorate(() -> this.queue.remainingCapacity(), span);
    }

    public boolean remove(Object element) {
        Span span = this.helper.buildSpan("remove", (DistributedObject)this.queue);
        span.setTag("element", TracingHelper.nullable(element));
        return TracingHelper.decorate(() -> this.queue.remove(element), span);
    }

    public boolean contains(Object element) {
        Span span = this.helper.buildSpan("contains", (DistributedObject)this.queue);
        span.setTag("element", TracingHelper.nullable(element));
        return TracingHelper.decorate(() -> this.queue.contains(element), span);
    }

    public int drainTo(Collection<? super E> collection) {
        Span span = this.helper.buildSpan("drainTo", (DistributedObject)this.queue);
        span.setTag("collection", collection.stream().map(TracingHelper::nullable).collect(Collectors.joining(", ")));
        return TracingHelper.decorate(() -> this.queue.drainTo(collection), span);
    }

    public int drainTo(Collection<? super E> collection, int maxElements) {
        Span span = this.helper.buildSpan("drainTo", (DistributedObject)this.queue);
        span.setTag("collection", collection.stream().map(TracingHelper::nullable).collect(Collectors.joining(", ")));
        span.setTag("maxElements", TracingHelper.nullable(maxElements));
        return TracingHelper.decorate(() -> this.queue.drainTo(collection, maxElements), span);
    }

    public E remove() {
        Span span = this.helper.buildSpan("remove", (DistributedObject)this.queue);
        return (E)TracingHelper.decorate(() -> this.queue.remove(), span);
    }

    public E element() {
        Span span = this.helper.buildSpan("element", (DistributedObject)this.queue);
        return (E)TracingHelper.decorate(() -> this.queue.element(), span);
    }

    public E peek() {
        Span span = this.helper.buildSpan("peek", (DistributedObject)this.queue);
        return (E)TracingHelper.decorate(() -> this.queue.peek(), span);
    }

    public int size() {
        Span span = this.helper.buildSpan("size", (DistributedObject)this.queue);
        return TracingHelper.decorate(() -> this.queue.size(), span);
    }

    public boolean isEmpty() {
        Span span = this.helper.buildSpan("isEmpty", (DistributedObject)this.queue);
        return TracingHelper.decorate(() -> this.queue.isEmpty(), span);
    }

    public Iterator<E> iterator() {
        Span span = this.helper.buildSpan("iterator", (DistributedObject)this.queue);
        return TracingHelper.decorate(() -> this.queue.iterator(), span);
    }

    public Object[] toArray() {
        Span span = this.helper.buildSpan("toArray", (DistributedObject)this.queue);
        return TracingHelper.decorate(() -> this.queue.toArray(), span);
    }

    public <T> T[] toArray(T[] a) {
        Span span = this.helper.buildSpan("toArray", (DistributedObject)this.queue);
        return TracingHelper.decorate(() -> this.queue.toArray(a), span);
    }

    public boolean containsAll(Collection<?> collection) {
        Span span = this.helper.buildSpan("containsAll", (DistributedObject)this.queue);
        span.setTag("collection", TracingHelper.nullable(collection));
        return TracingHelper.decorate(() -> this.queue.containsAll(collection), span);
    }

    public boolean addAll(Collection<? extends E> collection) {
        Span span = this.helper.buildSpan("addAll", (DistributedObject)this.queue);
        span.setTag("collection", TracingHelper.nullable(collection));
        return TracingHelper.decorate(() -> this.queue.addAll(collection), span);
    }

    public boolean removeAll(Collection<?> collection) {
        Span span = this.helper.buildSpan("removeAll", (DistributedObject)this.queue);
        span.setTag("collection", TracingHelper.nullable(collection));
        return TracingHelper.decorate(() -> this.queue.removeAll(collection), span);
    }

    public boolean removeIf(Predicate<? super E> filter) {
        Span span = this.helper.buildSpan("removeIf", (DistributedObject)this.queue);
        span.setTag("filter", TracingHelper.nullable(filter));
        return TracingHelper.decorate(() -> this.queue.removeIf(filter), span);
    }

    public boolean retainAll(Collection<?> collection) {
        Span span = this.helper.buildSpan("retainAll", (DistributedObject)this.queue);
        span.setTag("collection", TracingHelper.nullable(collection));
        return TracingHelper.decorate(() -> this.queue.retainAll(collection), span);
    }

    public void clear() {
        Span span = this.helper.buildSpan("clear", (DistributedObject)this.queue);
        TracingHelper.decorateAction(() -> this.queue.clear(), span);
    }

    public boolean equals(Object element) {
        return this.queue.equals(element);
    }

    public int hashCode() {
        return this.queue.hashCode();
    }

    public Spliterator<E> spliterator() {
        return this.queue.spliterator();
    }

    public Stream<E> stream() {
        return this.queue.stream();
    }

    public Stream<E> parallelStream() {
        return this.queue.parallelStream();
    }

    public void forEach(Consumer<? super E> action) {
        Span span = this.helper.buildSpan("forEach", (DistributedObject)this.queue);
        span.setTag("action", TracingHelper.nullableClass(action));
        TracingHelper.decorateAction(() -> this.queue.forEach(action), span);
    }

    public String getPartitionKey() {
        return this.queue.getPartitionKey();
    }

    public String getName() {
        return this.queue.getName();
    }

    public String getServiceName() {
        return this.queue.getServiceName();
    }

    public void destroy() {
        Span span = this.helper.buildSpan("destroy", (DistributedObject)this.queue);
        TracingHelper.decorateAction(() -> this.queue.destroy(), span);
    }

    public String addItemListener(ItemListener<E> listener, boolean includeValue) {
        Span span = this.helper.buildSpan("addItemListener", (DistributedObject)this.queue);
        span.setTag("listener", TracingHelper.nullableClass(listener));
        span.setTag("includeValue", includeValue);
        return TracingHelper.decorate(() -> this.queue.addItemListener(listener, includeValue), span);
    }

    public boolean removeItemListener(String registrationId) {
        Span span = this.helper.buildSpan("removeItemListener", (DistributedObject)this.queue);
        span.setTag("registrationId", registrationId);
        return TracingHelper.decorate(() -> this.queue.removeItemListener(registrationId), span);
    }
}

