/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.hazelcast;

import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.ReplicatedMap;
import com.hazelcast.monitor.LocalReplicatedMapStats;
import com.hazelcast.query.Predicate;
import io.opentracing.Span;
import io.opentracing.contrib.hazelcast.TracingHelper;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

public class TracingReplicatedMap<K, V>
implements ReplicatedMap<K, V> {
    private final ReplicatedMap<K, V> map;
    private final TracingHelper helper;

    public TracingReplicatedMap(ReplicatedMap<K, V> map, boolean traceWithActiveSpanOnly) {
        this.map = map;
        this.helper = new TracingHelper(traceWithActiveSpanOnly);
    }

    public V put(K key, V value, long ttl, TimeUnit timeUnit) {
        Span span = this.helper.buildSpan("put", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        span.setTag("ttl", (Number)ttl);
        span.setTag("timeUnit", TracingHelper.nullable((Object)timeUnit));
        return (V)TracingHelper.decorate(() -> this.map.put(key, value, ttl, timeUnit), span);
    }

    public void clear() {
        Span span = this.helper.buildSpan("clear", (DistributedObject)this.map);
        TracingHelper.decorateAction(() -> this.map.clear(), span);
    }

    public boolean removeEntryListener(String id) {
        Span span = this.helper.buildSpan("removeEntryListener", (DistributedObject)this.map);
        span.setTag("id", TracingHelper.nullable(id));
        return TracingHelper.decorate(() -> this.map.removeEntryListener(id), span);
    }

    public String addEntryListener(EntryListener<K, V> listener) {
        Span span = this.helper.buildSpan("addEntryListener", (DistributedObject)this.map);
        span.setTag("listener", TracingHelper.nullableClass(listener));
        return TracingHelper.decorate(() -> this.map.addEntryListener(listener), span);
    }

    public String addEntryListener(EntryListener<K, V> listener, K key) {
        Span span = this.helper.buildSpan("addEntryListener", (DistributedObject)this.map);
        span.setTag("listener", TracingHelper.nullableClass(listener));
        span.setTag("key", TracingHelper.nullable(key));
        return TracingHelper.decorate(() -> this.map.addEntryListener(listener, key), span);
    }

    public String addEntryListener(EntryListener<K, V> listener, Predicate<K, V> predicate) {
        Span span = this.helper.buildSpan("addEntryListener", (DistributedObject)this.map);
        span.setTag("listener", TracingHelper.nullableClass(listener));
        span.setTag("predicate", TracingHelper.nullable(predicate));
        return TracingHelper.decorate(() -> this.map.addEntryListener(listener, predicate), span);
    }

    public String addEntryListener(EntryListener<K, V> listener, Predicate<K, V> predicate, K key) {
        Span span = this.helper.buildSpan("addEntryListener", (DistributedObject)this.map);
        span.setTag("listener", TracingHelper.nullableClass(listener));
        span.setTag("predicate", TracingHelper.nullable(predicate));
        span.setTag("key", TracingHelper.nullable(key));
        return TracingHelper.decorate(() -> this.map.addEntryListener(listener, predicate, key), span);
    }

    public Collection<V> values() {
        Span span = this.helper.buildSpan("values", (DistributedObject)this.map);
        return TracingHelper.decorate(() -> this.map.values(), span);
    }

    public Collection<V> values(Comparator<V> comparator) {
        Span span = this.helper.buildSpan("values", (DistributedObject)this.map);
        span.setTag("comparator", TracingHelper.nullableClass(comparator));
        return TracingHelper.decorate(() -> this.map.values(comparator), span);
    }

    public Set<Map.Entry<K, V>> entrySet() {
        Span span = this.helper.buildSpan("entrySet", (DistributedObject)this.map);
        return TracingHelper.decorate(() -> this.map.entrySet(), span);
    }

    public Set<K> keySet() {
        Span span = this.helper.buildSpan("keySet", (DistributedObject)this.map);
        return TracingHelper.decorate(() -> this.map.keySet(), span);
    }

    public LocalReplicatedMapStats getReplicatedMapStats() {
        Span span = this.helper.buildSpan("getReplicatedMapStats", (DistributedObject)this.map);
        return TracingHelper.decorate(() -> this.map.getReplicatedMapStats(), span);
    }

    public int size() {
        Span span = this.helper.buildSpan("size", (DistributedObject)this.map);
        return TracingHelper.decorate(() -> this.map.size(), span);
    }

    public boolean isEmpty() {
        Span span = this.helper.buildSpan("isEmpty", (DistributedObject)this.map);
        return TracingHelper.decorate(() -> this.map.isEmpty(), span);
    }

    public boolean containsKey(Object key) {
        Span span = this.helper.buildSpan("containsKey", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        return TracingHelper.decorate(() -> this.map.containsKey(key), span);
    }

    public boolean containsValue(Object value) {
        Span span = this.helper.buildSpan("containsValue", (DistributedObject)this.map);
        span.setTag("value", TracingHelper.nullable(value));
        return TracingHelper.decorate(() -> this.map.containsValue(value), span);
    }

    public V get(Object key) {
        Span span = this.helper.buildSpan("get", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        return (V)TracingHelper.decorate(() -> this.map.get(key), span);
    }

    public V put(K key, V value) {
        Span span = this.helper.buildSpan("put", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        return (V)TracingHelper.decorate(() -> this.map.put(key, value), span);
    }

    public V remove(Object key) {
        Span span = this.helper.buildSpan("remove", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        return (V)TracingHelper.decorate(() -> this.map.remove(key), span);
    }

    public void putAll(Map<? extends K, ? extends V> m) {
        Span span = this.helper.buildSpan("putAll", (DistributedObject)this.map);
        span.setTag("mappings", TracingHelper.mapToString(m));
        TracingHelper.decorateAction(() -> this.map.putAll(m), span);
    }

    public boolean equals(Object o) {
        return this.map.equals(o);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public V getOrDefault(Object key, V defaultValue) {
        Span span = this.helper.buildSpan("getOrDefault", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("defaultValue", TracingHelper.nullable(defaultValue));
        return (V)TracingHelper.decorate(() -> this.map.getOrDefault(key, defaultValue), span);
    }

    public void forEach(BiConsumer<? super K, ? super V> action) {
        Span span = this.helper.buildSpan("forEach", (DistributedObject)this.map);
        span.setTag("action", TracingHelper.nullableClass(action));
        TracingHelper.decorateAction(() -> this.map.forEach(action), span);
    }

    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        Span span = this.helper.buildSpan("replaceAll", (DistributedObject)this.map);
        span.setTag("function", TracingHelper.nullableClass(function));
        TracingHelper.decorateAction(() -> this.map.replaceAll(function), span);
    }

    public V putIfAbsent(K key, V value) {
        Span span = this.helper.buildSpan("putIfAbsent", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        return (V)TracingHelper.decorate(() -> this.map.putIfAbsent(key, value), span);
    }

    public boolean remove(Object key, Object value) {
        Span span = this.helper.buildSpan("remove", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        return TracingHelper.decorate(() -> this.map.remove(key, value), span);
    }

    public boolean replace(K key, V oldValue, V newValue) {
        Span span = this.helper.buildSpan("replace", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("oldValue", TracingHelper.nullable(oldValue));
        span.setTag("newValue", TracingHelper.nullable(newValue));
        return TracingHelper.decorate(() -> this.map.replace(key, oldValue, newValue), span);
    }

    public V replace(K key, V value) {
        Span span = this.helper.buildSpan("replace", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        return (V)TracingHelper.decorate(() -> this.map.replace(key, value), span);
    }

    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        Span span = this.helper.buildSpan("computeIfAbsent", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("mappingFunction", TracingHelper.nullableClass(mappingFunction));
        return (V)TracingHelper.decorate(() -> this.map.computeIfAbsent(key, mappingFunction), span);
    }

    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Span span = this.helper.buildSpan("computeIfPresent", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("mappingFunction", TracingHelper.nullableClass(remappingFunction));
        return (V)TracingHelper.decorate(() -> this.map.computeIfPresent(key, remappingFunction), span);
    }

    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Span span = this.helper.buildSpan("compute", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("mappingFunction", TracingHelper.nullableClass(remappingFunction));
        return (V)TracingHelper.decorate(() -> this.map.compute(key, remappingFunction), span);
    }

    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        Span span = this.helper.buildSpan("merge", (DistributedObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        span.setTag("mappingFunction", TracingHelper.nullableClass(remappingFunction));
        return (V)TracingHelper.decorate(() -> this.map.merge(key, value, remappingFunction), span);
    }

    public String getPartitionKey() {
        return this.map.getPartitionKey();
    }

    public String getName() {
        return this.map.getName();
    }

    public String getServiceName() {
        return this.map.getServiceName();
    }

    public void destroy() {
        Span span = this.helper.buildSpan("destroy", (DistributedObject)this.map);
        TracingHelper.decorateAction(() -> this.map.destroy(), span);
    }
}

