/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.hazelcast;

import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.IFunction;
import com.hazelcast.ringbuffer.OverflowPolicy;
import com.hazelcast.ringbuffer.ReadResultSet;
import com.hazelcast.ringbuffer.Ringbuffer;
import io.opentracing.Span;
import io.opentracing.contrib.hazelcast.TracingCompletableFuture;
import io.opentracing.contrib.hazelcast.TracingHelper;
import java.util.Collection;

public class TracingRingbuffer<E>
implements Ringbuffer<E> {
    private final Ringbuffer<E> ringbuffer;
    private final TracingHelper helper;
    private final boolean traceWithActiveSpanOnly;

    public TracingRingbuffer(Ringbuffer<E> ringbuffer, boolean traceWithActiveSpanOnly) {
        this.ringbuffer = ringbuffer;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.helper = new TracingHelper(traceWithActiveSpanOnly);
    }

    public long capacity() {
        Span span = this.helper.buildSpan("capacity", (DistributedObject)this.ringbuffer);
        return TracingHelper.decorate(() -> this.ringbuffer.capacity(), span);
    }

    public long size() {
        Span span = this.helper.buildSpan("size", (DistributedObject)this.ringbuffer);
        return TracingHelper.decorate(() -> this.ringbuffer.size(), span);
    }

    public long tailSequence() {
        Span span = this.helper.buildSpan("tailSequence", (DistributedObject)this.ringbuffer);
        return TracingHelper.decorate(() -> this.ringbuffer.tailSequence(), span);
    }

    public long headSequence() {
        Span span = this.helper.buildSpan("headSequence", (DistributedObject)this.ringbuffer);
        return TracingHelper.decorate(() -> this.ringbuffer.headSequence(), span);
    }

    public long remainingCapacity() {
        Span span = this.helper.buildSpan("remainingCapacity", (DistributedObject)this.ringbuffer);
        return TracingHelper.decorate(() -> this.ringbuffer.remainingCapacity(), span);
    }

    public long add(E item) {
        Span span = this.helper.buildSpan("add", (DistributedObject)this.ringbuffer);
        span.setTag("item", TracingHelper.nullable(item));
        return TracingHelper.decorate(() -> this.ringbuffer.add(item), span);
    }

    public ICompletableFuture<Long> addAsync(E item, OverflowPolicy overflowPolicy) {
        Span span = this.helper.buildSpan("addAsync", (DistributedObject)this.ringbuffer);
        span.setTag("item", TracingHelper.nullable(item));
        span.setTag("overflowPolicy", TracingHelper.nullableClass(overflowPolicy));
        return TracingHelper.decorate(() -> new TracingCompletableFuture(this.ringbuffer.addAsync(item, overflowPolicy), this.traceWithActiveSpanOnly, TracingHelper.inject(span)), span);
    }

    public E readOne(long sequence) throws InterruptedException {
        Span span = this.helper.buildSpan("readOne", (DistributedObject)this.ringbuffer);
        span.setTag("sequence", (Number)sequence);
        return (E)TracingHelper.decorateExceptionally(() -> this.ringbuffer.readOne(sequence), span);
    }

    public ICompletableFuture<Long> addAllAsync(Collection<? extends E> collection, OverflowPolicy overflowPolicy) {
        Span span = this.helper.buildSpan("addAsync", (DistributedObject)this.ringbuffer);
        span.setTag("collection", TracingHelper.nullable(collection));
        span.setTag("overflowPolicy", TracingHelper.nullableClass(overflowPolicy));
        return TracingHelper.decorate(() -> new TracingCompletableFuture(this.ringbuffer.addAllAsync(collection, overflowPolicy), this.traceWithActiveSpanOnly, TracingHelper.inject(span)), span);
    }

    public ICompletableFuture<ReadResultSet<E>> readManyAsync(long startSequence, int minCount, int maxCount, IFunction<E, Boolean> filter) {
        Span span = this.helper.buildSpan("addAsync", (DistributedObject)this.ringbuffer);
        span.setTag("startSequence", (Number)startSequence);
        span.setTag("minCount", (Number)minCount);
        span.setTag("maxCount", (Number)maxCount);
        span.setTag("filter", TracingHelper.nullableClass(filter));
        return TracingHelper.decorate(() -> new TracingCompletableFuture(this.ringbuffer.readManyAsync(startSequence, minCount, maxCount, filter), this.traceWithActiveSpanOnly, TracingHelper.inject(span)), span);
    }

    public String getPartitionKey() {
        return this.ringbuffer.getPartitionKey();
    }

    public String getName() {
        return this.ringbuffer.getName();
    }

    public String getServiceName() {
        return this.ringbuffer.getServiceName();
    }

    public void destroy() {
        Span span = this.helper.buildSpan("destroy", (DistributedObject)this.ringbuffer);
        TracingHelper.decorateAction(() -> this.ringbuffer.destroy(), span);
    }
}

