/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.hazelcast;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.instance.Node;
import com.hazelcast.spi.NodeAware;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.spi.serialization.SerializationServiceAware;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.contrib.hazelcast.TracingHelper;
import java.io.Serializable;
import java.util.Map;

public class TracingRunnable
implements Runnable,
Serializable,
HazelcastInstanceAware,
NodeAware,
SerializationServiceAware {
    private final Runnable runnable;
    private final boolean traceWithActiveSpanOnly;
    private final Map<String, String> spanContextMap;

    public TracingRunnable(Runnable runnable, boolean traceWithActiveSpanOnly, Map<String, String> spanContextMap) {
        this.runnable = runnable;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.spanContextMap = spanContextMap;
    }

    @Override
    public void run() {
        SpanContext parent = TracingHelper.extract(this.spanContextMap);
        Span span = TracingHelper.buildSpan("process", parent, this.traceWithActiveSpanOnly);
        span.setTag("runnable", TracingHelper.nullableClass(this.runnable));
        TracingHelper.decorateAction(this.runnable::run, span);
    }

    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        if (this.runnable instanceof HazelcastInstanceAware) {
            ((HazelcastInstanceAware)this.runnable).setHazelcastInstance(hazelcastInstance);
        }
    }

    public void setNode(Node node) {
        if (this.runnable instanceof NodeAware) {
            ((NodeAware)this.runnable).setNode(node);
        }
    }

    public void setSerializationService(SerializationService serializationService) {
        if (this.runnable instanceof SerializationServiceAware) {
            ((SerializationServiceAware)this.runnable).setSerializationService(serializationService);
        }
    }
}

