/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.hazelcast;

import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.ISemaphore;
import io.opentracing.Span;
import io.opentracing.contrib.hazelcast.TracingHelper;
import java.util.concurrent.TimeUnit;

public class TracingSemaphore
implements ISemaphore {
    private final ISemaphore semaphore;
    private final TracingHelper helper;

    public TracingSemaphore(ISemaphore semaphore, boolean traceWithActiveSpanOnly) {
        this.semaphore = semaphore;
        this.helper = new TracingHelper(traceWithActiveSpanOnly);
    }

    public String getName() {
        return this.semaphore.getName();
    }

    public boolean init(int permits) {
        Span span = this.helper.buildSpan("init", (DistributedObject)this.semaphore);
        span.setTag("permits", (Number)permits);
        return TracingHelper.decorate(() -> this.semaphore.init(permits), span);
    }

    public void acquire() throws InterruptedException {
        Span span = this.helper.buildSpan("acquire", (DistributedObject)this.semaphore);
        TracingHelper.decorateActionExceptionally(() -> ((ISemaphore)this.semaphore).acquire(), span);
    }

    public void acquire(int permits) throws InterruptedException {
        Span span = this.helper.buildSpan("acquire", (DistributedObject)this.semaphore);
        span.setTag("permits", (Number)permits);
        TracingHelper.decorateActionExceptionally(() -> this.semaphore.acquire(permits), span);
    }

    public int availablePermits() {
        Span span = this.helper.buildSpan("availablePermits", (DistributedObject)this.semaphore);
        return TracingHelper.decorate(() -> ((ISemaphore)this.semaphore).availablePermits(), span);
    }

    public int drainPermits() {
        Span span = this.helper.buildSpan("drainPermits", (DistributedObject)this.semaphore);
        return TracingHelper.decorate(() -> ((ISemaphore)this.semaphore).drainPermits(), span);
    }

    public void reducePermits(int reduction) {
        Span span = this.helper.buildSpan("reducePermits", (DistributedObject)this.semaphore);
        span.setTag("reduction", (Number)reduction);
        TracingHelper.decorateAction(() -> this.semaphore.reducePermits(reduction), span);
    }

    public void increasePermits(int increase) {
        Span span = this.helper.buildSpan("increasePermits", (DistributedObject)this.semaphore);
        span.setTag("increase", (Number)increase);
        TracingHelper.decorateAction(() -> this.semaphore.increasePermits(increase), span);
    }

    public void release() {
        Span span = this.helper.buildSpan("release", (DistributedObject)this.semaphore);
        TracingHelper.decorateAction(() -> ((ISemaphore)this.semaphore).release(), span);
    }

    public void release(int permits) {
        Span span = this.helper.buildSpan("release", (DistributedObject)this.semaphore);
        span.setTag("permits", (Number)permits);
        TracingHelper.decorateAction(() -> this.semaphore.release(permits), span);
    }

    public boolean tryAcquire() {
        Span span = this.helper.buildSpan("tryAcquire", (DistributedObject)this.semaphore);
        return TracingHelper.decorate(() -> ((ISemaphore)this.semaphore).tryAcquire(), span);
    }

    public boolean tryAcquire(int permits) {
        Span span = this.helper.buildSpan("tryAcquire", (DistributedObject)this.semaphore);
        span.setTag("permits", (Number)permits);
        return TracingHelper.decorate(() -> this.semaphore.tryAcquire(permits), span);
    }

    public boolean tryAcquire(long timeout, TimeUnit unit) throws InterruptedException {
        Span span = this.helper.buildSpan("tryAcquire", (DistributedObject)this.semaphore);
        span.setTag("timeout", (Number)timeout);
        span.setTag("unit", TracingHelper.nullable((Object)unit));
        return TracingHelper.decorateExceptionally(() -> this.semaphore.tryAcquire(timeout, unit), span);
    }

    public boolean tryAcquire(int permits, long timeout, TimeUnit unit) throws InterruptedException {
        Span span = this.helper.buildSpan("tryAcquire", (DistributedObject)this.semaphore);
        span.setTag("permits", (Number)permits);
        span.setTag("timeout", (Number)timeout);
        span.setTag("unit", TracingHelper.nullable((Object)unit));
        return TracingHelper.decorateExceptionally(() -> this.semaphore.tryAcquire(permits, timeout, unit), span);
    }

    public String getPartitionKey() {
        return this.semaphore.getPartitionKey();
    }

    public String getServiceName() {
        return this.semaphore.getServiceName();
    }

    public void destroy() {
        Span span = this.helper.buildSpan("destroy", (DistributedObject)this.semaphore);
        TracingHelper.decorateAction(() -> ((ISemaphore)this.semaphore).destroy(), span);
    }
}

