/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.hazelcast;

import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.ISet;
import com.hazelcast.core.ItemListener;
import io.opentracing.Span;
import io.opentracing.contrib.hazelcast.TracingHelper;
import java.util.Collection;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class TracingSet<E>
implements ISet<E> {
    private final ISet<E> set;
    private final TracingHelper helper;
    private final boolean traceWithActiveSpanOnly;

    public TracingSet(ISet<E> set, boolean traceWithActiveSpanOnly) {
        this.set = set;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.helper = new TracingHelper(traceWithActiveSpanOnly);
    }

    public int size() {
        Span span = this.helper.buildSpan("size", (DistributedObject)this.set);
        return TracingHelper.decorate(() -> this.set.size(), span);
    }

    public boolean isEmpty() {
        Span span = this.helper.buildSpan("isEmpty", (DistributedObject)this.set);
        return TracingHelper.decorate(() -> this.set.isEmpty(), span);
    }

    public boolean contains(Object element) {
        Span span = this.helper.buildSpan("contains", (DistributedObject)this.set);
        span.setTag("element", TracingHelper.nullable(element));
        return TracingHelper.decorate(() -> this.set.contains(element), span);
    }

    public Iterator<E> iterator() {
        Span span = this.helper.buildSpan("iterator", (DistributedObject)this.set);
        return TracingHelper.decorate(() -> this.set.iterator(), span);
    }

    public Object[] toArray() {
        Span span = this.helper.buildSpan("toArray", (DistributedObject)this.set);
        return TracingHelper.decorate(() -> this.set.toArray(), span);
    }

    public <T> T[] toArray(T[] a) {
        Span span = this.helper.buildSpan("toArray", (DistributedObject)this.set);
        return TracingHelper.decorate(() -> this.set.toArray(a), span);
    }

    public boolean add(E element) {
        Span span = this.helper.buildSpan("add", (DistributedObject)this.set);
        span.setTag("element", TracingHelper.nullable(element));
        return TracingHelper.decorate(() -> this.set.add(element), span);
    }

    public boolean remove(Object element) {
        Span span = this.helper.buildSpan("remove", (DistributedObject)this.set);
        span.setTag("element", TracingHelper.nullable(element));
        return TracingHelper.decorate(() -> this.set.remove(element), span);
    }

    public boolean containsAll(Collection<?> collection) {
        Span span = this.helper.buildSpan("containsAll", (DistributedObject)this.set);
        span.setTag("collection", TracingHelper.nullable(collection));
        return TracingHelper.decorate(() -> this.set.containsAll(collection), span);
    }

    public boolean addAll(Collection<? extends E> collection) {
        Span span = this.helper.buildSpan("addAll", (DistributedObject)this.set);
        span.setTag("collection", TracingHelper.nullable(collection));
        return TracingHelper.decorate(() -> this.set.addAll(collection), span);
    }

    public boolean retainAll(Collection<?> collection) {
        Span span = this.helper.buildSpan("retainAll", (DistributedObject)this.set);
        span.setTag("collection", TracingHelper.nullable(collection));
        return TracingHelper.decorate(() -> this.set.retainAll(collection), span);
    }

    public boolean removeAll(Collection<?> collection) {
        Span span = this.helper.buildSpan("removeAll", (DistributedObject)this.set);
        span.setTag("collection", TracingHelper.nullable(collection));
        return TracingHelper.decorate(() -> this.set.removeAll(collection), span);
    }

    public void clear() {
        Span span = this.helper.buildSpan("clear", (DistributedObject)this.set);
        TracingHelper.decorateAction(() -> this.set.clear(), span);
    }

    public boolean equals(Object o) {
        return this.set.equals(o);
    }

    public int hashCode() {
        return this.set.hashCode();
    }

    public Spliterator<E> spliterator() {
        return this.set.spliterator();
    }

    public boolean removeIf(Predicate<? super E> filter) {
        Span span = this.helper.buildSpan("removeIf", (DistributedObject)this.set);
        span.setTag("filter", TracingHelper.nullable(filter));
        return TracingHelper.decorate(() -> this.set.removeIf(filter), span);
    }

    public Stream<E> stream() {
        return this.set.stream();
    }

    public Stream<E> parallelStream() {
        return this.set.parallelStream();
    }

    public void forEach(Consumer<? super E> action) {
        Span span = this.helper.buildSpan("forEach", (DistributedObject)this.set);
        span.setTag("action", TracingHelper.nullableClass(action));
        TracingHelper.decorateAction(() -> this.set.forEach(action), span);
    }

    public String getName() {
        return this.set.getName();
    }

    public String addItemListener(ItemListener<E> listener, boolean includeValue) {
        Span span = this.helper.buildSpan("addItemListener", (DistributedObject)this.set);
        span.setTag("listener", TracingHelper.nullableClass(listener));
        span.setTag("includeValue", includeValue);
        return TracingHelper.decorate(() -> this.set.addItemListener(listener, includeValue), span);
    }

    public boolean removeItemListener(String registrationId) {
        Span span = this.helper.buildSpan("removeItemListener", (DistributedObject)this.set);
        span.setTag("registrationId", registrationId);
        return TracingHelper.decorate(() -> this.set.removeItemListener(registrationId), span);
    }

    public String getPartitionKey() {
        return this.set.getPartitionKey();
    }

    public String getServiceName() {
        return this.set.getServiceName();
    }

    public void destroy() {
        Span span = this.helper.buildSpan("destroy", (DistributedObject)this.set);
        TracingHelper.decorateAction(() -> this.set.destroy(), span);
    }
}

