/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.hazelcast;

import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.MessageListener;
import com.hazelcast.monitor.LocalTopicStats;
import io.opentracing.Span;
import io.opentracing.contrib.hazelcast.TracingHelper;
import io.opentracing.contrib.hazelcast.TracingMessage;
import io.opentracing.contrib.hazelcast.TracingMessageListener;
import java.util.Map;

public class TracingTopic<E>
implements ITopic<E> {
    private final ITopic<TracingMessage<E>> topic;
    private final TracingHelper helper;
    private final boolean traceWithActiveSpanOnly;

    public TracingTopic(String topic, boolean reliable, HazelcastInstance instance, boolean traceWithActiveSpanOnly) {
        this.topic = reliable ? instance.getReliableTopic(topic) : instance.getTopic(topic);
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
        this.helper = new TracingHelper(traceWithActiveSpanOnly);
    }

    public String getName() {
        return this.topic.getName();
    }

    public void publish(E message) {
        Span span = this.helper.buildSpan("publish", (DistributedObject)this.topic);
        span.setTag("message", TracingHelper.nullable(message));
        Map<String, String> spanContextMap = TracingHelper.inject(span);
        TracingHelper.decorateAction(() -> this.topic.publish(new TracingMessage<Object>(message, spanContextMap)), span);
    }

    public String addMessageListener(MessageListener<E> listener) {
        Span span = this.helper.buildSpan("addMessageListener", (DistributedObject)this.topic);
        span.setTag("listener", TracingHelper.nullableClass(listener));
        return TracingHelper.decorate(() -> this.topic.addMessageListener(new TracingMessageListener(listener, this.topic.getName(), this.traceWithActiveSpanOnly)), span);
    }

    public boolean removeMessageListener(String registrationId) {
        Span span = this.helper.buildSpan("removeMessageListener", (DistributedObject)this.topic);
        span.setTag("registrationId", TracingHelper.nullable(registrationId));
        return TracingHelper.decorate(() -> this.topic.removeMessageListener(registrationId), span);
    }

    public LocalTopicStats getLocalTopicStats() {
        Span span = this.helper.buildSpan("getLocalTopicStats", (DistributedObject)this.topic);
        return TracingHelper.decorate(() -> this.topic.getLocalTopicStats(), span);
    }

    public String getPartitionKey() {
        return this.topic.getPartitionKey();
    }

    public String getServiceName() {
        return this.topic.getServiceName();
    }

    public void destroy() {
        Span span = this.helper.buildSpan("destroy", (DistributedObject)this.topic);
        TracingHelper.decorateAction(() -> this.topic.destroy(), span);
    }
}

