package io.opentracing.contrib.jaxrs2.client;

import io.opentracing.References;

/**
 * @author Pavol Loffay
 */
public class TracingProperties {

    private TracingProperties() {}

    /**
     * Denotes a "parent" get ({@link io.opentracing.References#CHILD_OF}).
     * If it is not specified a new trace will be started.
     * Value should be {@link io.opentracing.SpanContext}.
     * Set on {@link javax.ws.rs.client.Client#property(String, Object)}.
     */
    public static final String CHILD_OF = SpanClientRequestFilter.class.getName() + "." + References.CHILD_OF;

    /**
     * Indicates whether request should be traced or not. If it is not
     * present and client is correctly configured requests will be traced.
     * Value should be boolean true or false (trace disabled/enabled).
     * Set on {@link javax.ws.rs.client.Client#property(String, Object)}.
     */
    public static final String TRACING_DISABLED = SpanClientRequestFilter.class.getName() + ".tracingDisabled";
}
