/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jaxrs2.client;

import io.opentracing.Tracer;
import io.opentracing.contrib.jaxrs2.client.ClientSpanDecorator;
import io.opentracing.contrib.jaxrs2.client.SpanClientRequestFilter;
import io.opentracing.contrib.jaxrs2.client.SpanClientResponseFilter;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.client.Client;

public class ClientTracingFeature {
    private static final Logger log = Logger.getLogger(ClientTracingFeature.class.getName());

    private ClientTracingFeature(Builder builder) {
        if (log.isLoggable(Level.INFO)) {
            log.info("Registering client tracing for: " + builder.client);
        }
        ((Client)builder.client.register((Object)new SpanClientRequestFilter(builder.tracer, builder.spanDecorators), 0)).register((Object)new SpanClientResponseFilter(builder.spanDecorators), 0);
    }

    public static class Builder {
        private Tracer tracer;
        private Client client;
        private List<ClientSpanDecorator> spanDecorators;

        private Builder(Tracer tracer, Client client) {
            this.tracer = tracer;
            this.client = client;
            this.spanDecorators = Arrays.asList(ClientSpanDecorator.STANDARD_TAGS);
        }

        public static Builder traceAll(Tracer tracer, Client client) {
            Builder builder = new Builder(tracer, client);
            return builder;
        }

        public Builder withDecorators(List<ClientSpanDecorator> spanDecorators) {
            this.spanDecorators = spanDecorators;
            return this;
        }

        public Tracer tracer() {
            return this.tracer;
        }

        public Client client() {
            return this.client;
        }

        public Client build() {
            new ClientTracingFeature(this);
            return this.client;
        }
    }
}

