/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jaxrs2.client;

import io.opentracing.contrib.jaxrs2.client.ClientSpanDecorator;
import io.opentracing.contrib.jaxrs2.internal.CastUtils;
import io.opentracing.contrib.jaxrs2.internal.SpanWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;

public class SpanClientResponseFilter
implements ClientResponseFilter {
    private static final Logger log = Logger.getLogger(SpanClientResponseFilter.class.getName());
    private List<ClientSpanDecorator> spanDecorators;

    public SpanClientResponseFilter(List<ClientSpanDecorator> spanDecorators) {
        this.spanDecorators = new ArrayList<ClientSpanDecorator>(spanDecorators);
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        SpanWrapper spanWrapper = CastUtils.cast(requestContext.getProperty("activeClientSpan"), SpanWrapper.class);
        if (spanWrapper != null && !spanWrapper.isFinished()) {
            log.finest("Finishing client span");
            if (this.spanDecorators != null) {
                for (ClientSpanDecorator decorator : this.spanDecorators) {
                    decorator.decorateResponse(responseContext, spanWrapper.get());
                }
            }
            spanWrapper.finish();
        }
    }
}

