/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jaxrs2.server;

import io.opentracing.contrib.jaxrs2.internal.CastUtils;
import io.opentracing.contrib.jaxrs2.internal.SpanWrapper;
import io.opentracing.contrib.jaxrs2.server.ServerSpanDecorator;
import io.opentracing.contrib.jaxrs2.server.SpanServerRequestFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;

@Priority(value=3000)
public class SpanServerResponseFilter
implements ContainerResponseFilter {
    private static final Logger log = Logger.getLogger(SpanServerResponseFilter.class.getName());
    private List<ServerSpanDecorator> spanDecorators;

    public SpanServerResponseFilter(List<ServerSpanDecorator> spanDecorators) {
        this.spanDecorators = new ArrayList<ServerSpanDecorator>(spanDecorators);
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        SpanWrapper spanWrapper = CastUtils.cast(requestContext.getProperty(SpanServerRequestFilter.SPAN_PROP_ID), SpanWrapper.class);
        if (spanWrapper != null && !spanWrapper.isFinished()) {
            log.finest("Finishing server span");
            if (this.spanDecorators != null) {
                for (ServerSpanDecorator decorator : this.spanDecorators) {
                    decorator.decorateResponse(responseContext, spanWrapper.get());
                }
            }
            spanWrapper.finish();
        }
    }
}

