/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jaxrs2.client;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.contrib.jaxrs2.client.ClientHeadersInjectTextMap;
import io.opentracing.contrib.jaxrs2.client.ClientSpanDecorator;
import io.opentracing.contrib.jaxrs2.client.TracingProperties;
import io.opentracing.contrib.jaxrs2.internal.CastUtils;
import io.opentracing.contrib.jaxrs2.internal.SpanWrapper;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Priority;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.MultivaluedMap;

@Priority(value=3000)
public class ClientTracingFilter
implements ClientRequestFilter,
ClientResponseFilter {
    private static final Logger log = Logger.getLogger(ClientTracingFilter.class.getName());
    protected static final String SPAN_PROP_ID = "activeClientSpan";
    private Tracer tracer;
    private List<ClientSpanDecorator> spanDecorators;

    protected ClientTracingFilter(Tracer tracer, List<ClientSpanDecorator> spanDecorators) {
        this.tracer = tracer;
        this.spanDecorators = new ArrayList<ClientSpanDecorator>(spanDecorators);
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        Boolean tracingDisabled = CastUtils.cast(requestContext.getProperty(TracingProperties.TRACING_DISABLED), Boolean.class);
        if (tracingDisabled != null && tracingDisabled.booleanValue()) {
            log.finest("Client tracing disabled");
            return;
        }
        if (requestContext.getProperty(SPAN_PROP_ID) != null) {
            return;
        }
        Tracer.SpanBuilder spanBuilder = this.tracer.buildSpan(requestContext.getMethod()).withTag(Tags.SPAN_KIND.getKey(), "client");
        SpanContext parentSpanContext = CastUtils.cast(requestContext.getProperty(TracingProperties.CHILD_OF), SpanContext.class);
        if (parentSpanContext != null) {
            spanBuilder.asChildOf(parentSpanContext);
        }
        Span span = spanBuilder.start();
        if (this.spanDecorators != null) {
            for (ClientSpanDecorator decorator : this.spanDecorators) {
                decorator.decorateRequest(requestContext, span);
            }
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Starting client span");
        }
        this.tracer.inject(span.context(), Format.Builtin.HTTP_HEADERS, (Object)new ClientHeadersInjectTextMap((MultivaluedMap<String, Object>)requestContext.getHeaders()));
        requestContext.setProperty(SPAN_PROP_ID, (Object)new SpanWrapper(span));
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        SpanWrapper spanWrapper = CastUtils.cast(requestContext.getProperty(SPAN_PROP_ID), SpanWrapper.class);
        if (spanWrapper != null && !spanWrapper.isFinished()) {
            log.finest("Finishing client span");
            if (this.spanDecorators != null) {
                for (ClientSpanDecorator decorator : this.spanDecorators) {
                    decorator.decorateResponse(responseContext, spanWrapper.get());
                }
            }
            spanWrapper.finish();
        }
    }
}

