/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jaxrs2.server;

import io.opentracing.Tracer;
import io.opentracing.contrib.jaxrs2.server.ServerSpanDecorator;
import io.opentracing.contrib.jaxrs2.server.ServerTracingFilter;
import io.opentracing.contrib.jaxrs2.server.Traced;
import io.opentracing.util.GlobalTracer;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.ext.Provider;

@Provider
public class ServerTracingDynamicFeature
implements DynamicFeature {
    private static final Logger log = Logger.getLogger(ServerTracingDynamicFeature.class.getName());
    private Builder builder;

    public ServerTracingDynamicFeature() {
        this(new Builder(GlobalTracer.get()));
    }

    private ServerTracingDynamicFeature(Builder builder) {
        this.builder = builder;
    }

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        if (this.builder.allTraced || this.shouldBeTraced(resourceInfo)) {
            if (log.isLoggable(Level.INFO)) {
                String msg = String.format("%s registering tracing: %s#%s", this, resourceInfo.getResourceClass().getCanonicalName(), resourceInfo.getResourceMethod().getName());
                log.info(msg);
            }
            context.register((Object)new ServerTracingFilter(this.builder.tracer, this.operationName(resourceInfo), this.builder.spanDecorators), this.builder.priority);
        }
    }

    protected Traced closestTracedAnnotation(ResourceInfo resourceInfo) {
        Traced tracedAnnotation = resourceInfo.getResourceClass().getAnnotation(Traced.class);
        if (tracedAnnotation == null) {
            tracedAnnotation = resourceInfo.getResourceMethod().getAnnotation(Traced.class);
        }
        return tracedAnnotation;
    }

    protected boolean shouldBeTraced(ResourceInfo resourceInfo) {
        return this.closestTracedAnnotation(resourceInfo) != null;
    }

    protected String operationName(ResourceInfo resourceInfo) {
        Traced traced = this.closestTracedAnnotation(resourceInfo);
        return traced != null ? traced.operationName() : null;
    }

    public static class Builder {
        private final Tracer tracer;
        private boolean allTraced;
        private List<ServerSpanDecorator> spanDecorators;
        private int priority;

        public Builder(Tracer tracer) {
            this.tracer = tracer;
            this.spanDecorators = Arrays.asList(ServerSpanDecorator.HTTP_WILDCARD_PATH_OPERATION_NAME, ServerSpanDecorator.STANDARD_TAGS);
            this.priority = 3000;
            this.allTraced = true;
        }

        public Builder withTraceNothing() {
            this.allTraced = false;
            return this;
        }

        public Builder withDecorators(List<ServerSpanDecorator> spanDecorators) {
            this.spanDecorators = spanDecorators;
            return this;
        }

        public Builder withPriority(int priority) {
            this.priority = priority;
            return this;
        }

        public ServerTracingDynamicFeature build() {
            return new ServerTracingDynamicFeature(this);
        }
    }
}

