/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jaxrs2.server;

import io.opentracing.Tracer;
import io.opentracing.contrib.jaxrs2.server.ServerSpanDecorator;
import io.opentracing.contrib.jaxrs2.server.ServerTracingFilter;
import io.opentracing.contrib.jaxrs2.server.Traced;
import io.opentracing.util.GlobalTracer;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.ext.Provider;

@Provider
public class ServerTracingDynamicFeature
implements DynamicFeature {
    private static final Logger log = Logger.getLogger(ServerTracingDynamicFeature.class.getName());
    private final Builder builder;
    private boolean logged = false;

    public ServerTracingDynamicFeature() {
        this(new Builder(GlobalTracer.get()));
    }

    private ServerTracingDynamicFeature(Builder builder) {
        this.builder = builder;
    }

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        if (this.builder.allTraced || this.shouldBeTraced(resourceInfo)) {
            this.log(resourceInfo);
            context.register((Object)new ServerTracingFilter(this.builder.tracer, this.operationName(resourceInfo), this.builder.spanDecorators, this.isSyncRequest(resourceInfo)), this.builder.priority);
        }
    }

    private void log(ResourceInfo resourceInfo) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.format("Registering tracing on %s#%s...", resourceInfo.getResourceClass().getCanonicalName(), resourceInfo.getResourceMethod().getName()));
        } else if (!this.logged) {
            log.info("Registering tracing on deployed resources...");
        }
        this.logged = true;
    }

    protected Traced closestTracedAnnotation(ResourceInfo resourceInfo) {
        Traced tracedAnnotation = resourceInfo.getResourceClass().getAnnotation(Traced.class);
        if (tracedAnnotation == null) {
            tracedAnnotation = resourceInfo.getResourceMethod().getAnnotation(Traced.class);
        }
        return tracedAnnotation;
    }

    protected boolean shouldBeTraced(ResourceInfo resourceInfo) {
        return this.closestTracedAnnotation(resourceInfo) != null;
    }

    protected String operationName(ResourceInfo resourceInfo) {
        Traced traced = this.closestTracedAnnotation(resourceInfo);
        return traced != null ? traced.operationName() : null;
    }

    protected boolean isSyncRequest(ResourceInfo resourceInfo) {
        if (resourceInfo == null) {
            return false;
        }
        Annotation[][] annotationArray = resourceInfo.getResourceMethod().getParameterAnnotations();
        int n = annotationArray.length;
        for (int i = 0; i < n; ++i) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = annotationArray[i]) {
                if (!annotation.annotationType().equals(Suspended.class)) continue;
                return false;
            }
        }
        return true;
    }

    public static class Builder {
        private final Tracer tracer;
        private boolean allTraced;
        private List<ServerSpanDecorator> spanDecorators;
        private int priority;

        public Builder(Tracer tracer) {
            this.tracer = tracer;
            this.spanDecorators = Arrays.asList(ServerSpanDecorator.HTTP_WILDCARD_PATH_OPERATION_NAME, ServerSpanDecorator.STANDARD_TAGS);
            this.priority = 3000;
            this.allTraced = true;
        }

        public Builder withTraceNothing() {
            this.allTraced = false;
            return this;
        }

        public Builder withDecorators(List<ServerSpanDecorator> spanDecorators) {
            this.spanDecorators = spanDecorators;
            return this;
        }

        public Builder withPriority(int priority) {
            this.priority = priority;
            return this;
        }

        public ServerTracingDynamicFeature build() {
            return new ServerTracingDynamicFeature(this);
        }
    }
}

