/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jaxrs2.server;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.MultivaluedMap;

public interface OperationNameProvider {
    public String operationName(ContainerRequestContext var1);

    public static class WildcardOperationName
    implements OperationNameProvider {
        WildcardOperationName() {
        }

        @Override
        public String operationName(ContainerRequestContext requestContext) {
            MultivaluedMap pathParameters = requestContext.getUriInfo().getPathParameters();
            String path = requestContext.getUriInfo().getPath();
            if (path.isEmpty() || path.charAt(0) != '/') {
                path = "/" + path;
            }
            for (Map.Entry entry : pathParameters.entrySet()) {
                String originalPathFragment = String.format("{%s}", entry.getKey());
                for (String currentPathFragment : (List)entry.getValue()) {
                    path = path.replace(currentPathFragment, originalPathFragment);
                }
            }
            return requestContext.getMethod() + ":" + path;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        static class Builder
        implements io.opentracing.contrib.jaxrs2.server.OperationNameProvider$Builder {
            Builder() {
            }

            @Override
            public OperationNameProvider build(Class<?> clazz, Method method) {
                return new WildcardOperationName();
            }
        }
    }

    public static class ClassNameOperationName
    implements OperationNameProvider {
        private String classMethod;

        ClassNameOperationName(Class<?> clazz, Method method) {
            this.classMethod = String.format("%s.%s", clazz.getName(), method.getName());
        }

        @Override
        public String operationName(ContainerRequestContext requestContext) {
            return String.format("%s:%s", requestContext.getMethod(), this.classMethod);
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        static class Builder
        implements io.opentracing.contrib.jaxrs2.server.OperationNameProvider$Builder {
            Builder() {
            }

            @Override
            public OperationNameProvider build(Class<?> clazz, Method method) {
                return new ClassNameOperationName(clazz, method);
            }
        }
    }

    public static class HTTPMethodOperationName
    implements OperationNameProvider {
        HTTPMethodOperationName() {
        }

        @Override
        public String operationName(ContainerRequestContext requestContext) {
            return requestContext.getMethod();
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        static class Builder
        implements io.opentracing.contrib.jaxrs2.server.OperationNameProvider$Builder {
            Builder() {
            }

            @Override
            public OperationNameProvider build(Class<?> clazz, Method method) {
                return new HTTPMethodOperationName();
            }
        }
    }

    public static interface Builder {
        public OperationNameProvider build(Class<?> var1, Method var2);
    }
}

