/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jdbc;

import io.opentracing.Scope;
import io.opentracing.Tracer;
import io.opentracing.contrib.jdbc.ConnectionInfo;
import io.opentracing.contrib.jdbc.JdbcTracingUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Set;

public class TracingStatement
implements Statement {
    private final Statement statement;
    private final String query;
    private final ArrayList<String> batchCommands = new ArrayList();
    private final ConnectionInfo connectionInfo;
    private final boolean withActiveSpanOnly;
    private final Set<String> ignoredStatements;
    private Tracer tracer;

    TracingStatement(Statement statement, ConnectionInfo connectionInfo, boolean withActiveSpanOnly, Set<String> ignoredStatements) {
        this(statement, connectionInfo, withActiveSpanOnly, ignoredStatements, null);
    }

    TracingStatement(Statement statement, ConnectionInfo connectionInfo, boolean withActiveSpanOnly, Set<String> ignoredStatements, Tracer tracer) {
        this(statement, null, connectionInfo, withActiveSpanOnly, ignoredStatements, tracer);
    }

    TracingStatement(Statement statement, String query, ConnectionInfo connectionInfo, boolean withActiveSpanOnly, Set<String> ignoredStatements) {
        this(statement, query, connectionInfo, withActiveSpanOnly, ignoredStatements, null);
    }

    TracingStatement(Statement statement, String query, ConnectionInfo connectionInfo, boolean withActiveSpanOnly, Set<String> ignoredStatements, Tracer tracer) {
        this.statement = statement;
        this.query = query;
        this.connectionInfo = connectionInfo;
        this.withActiveSpanOnly = withActiveSpanOnly;
        this.ignoredStatements = ignoredStatements;
        this.tracer = tracer;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        try (Scope scope = JdbcTracingUtils.buildScope("Query", sql, this.connectionInfo, this.withActiveSpanOnly, this.ignoredStatements, this.tracer);){
            ResultSet resultSet = this.statement.executeQuery(sql);
            return resultSet;
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        try (Scope scope = JdbcTracingUtils.buildScope("Update", sql, this.connectionInfo, this.withActiveSpanOnly, this.ignoredStatements, this.tracer);){
            int n = this.statement.executeUpdate(sql);
            return n;
        }
    }

    @Override
    public void close() throws SQLException {
        this.statement.close();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.statement.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.statement.setMaxFieldSize(max);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.statement.getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.statement.setMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.statement.setEscapeProcessing(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.statement.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.statement.setQueryTimeout(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        this.statement.cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.statement.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.statement.clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.statement.setCursorName(name);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        try (Scope scope = JdbcTracingUtils.buildScope("Execute", sql, this.connectionInfo, this.withActiveSpanOnly, this.ignoredStatements, this.tracer);){
            boolean bl = this.statement.execute(sql);
            return bl;
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.statement.getResultSet();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.statement.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.statement.getMoreResults();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.statement.setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.statement.getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.statement.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.statement.getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.statement.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.statement.getResultSetType();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.statement.addBatch(sql);
        this.batchCommands.add(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.statement.clearBatch();
        this.batchCommands.clear();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        try (Scope scope = this.buildScopeForBatch();){
            int[] nArray = this.statement.executeBatch();
            return nArray;
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.statement.getConnection();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.statement.getMoreResults(current);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.statement.getGeneratedKeys();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        try (Scope scope = JdbcTracingUtils.buildScope("Update", sql, this.connectionInfo, this.withActiveSpanOnly, this.ignoredStatements, this.tracer);){
            int n = this.statement.executeUpdate(sql, autoGeneratedKeys);
            return n;
        }
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        try (Scope scope = JdbcTracingUtils.buildScope("Update", sql, this.connectionInfo, this.withActiveSpanOnly, this.ignoredStatements, this.tracer);){
            int n = this.statement.executeUpdate(sql, columnIndexes);
            return n;
        }
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        try (Scope scope = JdbcTracingUtils.buildScope("Update", sql, this.connectionInfo, this.withActiveSpanOnly, this.ignoredStatements, this.tracer);){
            int n = this.statement.executeUpdate(sql, columnNames);
            return n;
        }
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        try (Scope scope = JdbcTracingUtils.buildScope("Execute", sql, this.connectionInfo, this.withActiveSpanOnly, this.ignoredStatements, this.tracer);){
            boolean bl = this.statement.execute(sql, autoGeneratedKeys);
            return bl;
        }
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        try (Scope scope = JdbcTracingUtils.buildScope("Execute", sql, this.connectionInfo, this.withActiveSpanOnly, this.ignoredStatements, this.tracer);){
            boolean bl = this.statement.execute(sql, columnIndexes);
            return bl;
        }
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        try (Scope scope = JdbcTracingUtils.buildScope("Execute", sql, this.connectionInfo, this.withActiveSpanOnly, this.ignoredStatements, this.tracer);){
            boolean bl = this.statement.execute(sql, columnNames);
            return bl;
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.statement.getResultSetHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.statement.isClosed();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.statement.setPoolable(poolable);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.statement.isPoolable();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.statement.closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.statement.isCloseOnCompletion();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.statement.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.statement.isWrapperFor(iface);
    }

    private Scope buildScopeForBatch() {
        StringBuilder sqlBuilder = new StringBuilder();
        if (this.query != null) {
            sqlBuilder.append(this.query);
        }
        for (String batchCommand : this.batchCommands) {
            sqlBuilder.append(batchCommand);
        }
        return JdbcTracingUtils.buildScope("Batch", sqlBuilder.toString(), this.connectionInfo, this.withActiveSpanOnly, this.ignoredStatements, this.tracer);
    }
}

