/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jdbc;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.noop.NoopScopeManager;
import io.opentracing.tag.Tags;
import io.opentracing.util.GlobalTracer;

class JdbcTracingUtils {
    static final String COMPONENT_NAME = "java-jdbc";

    JdbcTracingUtils() {
    }

    static Scope buildScope(String operationName, String sql, String dbType, String dbUser, boolean withActiveSpanOnly) {
        if (withActiveSpanOnly && GlobalTracer.get().activeSpan() == null) {
            return NoopScopeManager.NoopScope.INSTANCE;
        }
        Tracer.SpanBuilder spanBuilder = GlobalTracer.get().buildSpan(operationName).withTag(Tags.SPAN_KIND.getKey(), "client");
        Scope scope = spanBuilder.startActive(true);
        JdbcTracingUtils.decorate(scope.span(), sql, dbType, dbUser);
        return scope;
    }

    private static void decorate(Span span, String sql, String dbType, String dbUser) {
        Tags.COMPONENT.set(span, COMPONENT_NAME);
        Tags.DB_STATEMENT.set(span, sql);
        Tags.DB_TYPE.set(span, dbType);
        if (dbUser != null) {
            Tags.DB_USER.set(span, dbUser);
        }
    }
}

