/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jdbc.parser;

import io.opentracing.contrib.jdbc.ConnectionInfo;
import io.opentracing.contrib.jdbc.parser.AbstractURLParser;
import io.opentracing.contrib.jdbc.parser.URLLocation;
import java.util.ArrayList;
import java.util.List;

public class OracleURLParser
extends AbstractURLParser {
    public static final String SERVICE_NAME_FLAG = "@//";
    public static final String TNSNAME_URL_FLAG = "DESCRIPTION";
    private static final String DB_TYPE = "oracle";
    private static final int DEFAULT_PORT = 1521;

    @Override
    protected URLLocation fetchDatabaseHostsIndexRange(String url) {
        int hostLabelStartIndex = this.isServiceNameURL(url) ? url.indexOf(SERVICE_NAME_FLAG) + 3 : url.indexOf("@") + 1;
        int hostLabelEndIndex = url.lastIndexOf(":");
        return new URLLocation(hostLabelStartIndex, hostLabelEndIndex);
    }

    @Override
    protected URLLocation fetchDatabaseNameIndexRange(String url) {
        int hostLabelStartIndex;
        int hostLabelEndIndex = url.length();
        if (this.isServiceNameURL(url)) {
            hostLabelStartIndex = url.lastIndexOf("/") + 1;
        } else if (this.isTNSNameURL(url)) {
            hostLabelStartIndex = url.indexOf("=", url.indexOf("SERVICE_NAME")) + 1;
            hostLabelEndIndex = url.indexOf(")", hostLabelStartIndex);
        } else {
            hostLabelStartIndex = url.lastIndexOf(":") + 1;
        }
        return new URLLocation(hostLabelStartIndex, hostLabelEndIndex);
    }

    private boolean isServiceNameURL(String url) {
        return url.contains(SERVICE_NAME_FLAG);
    }

    private boolean isTNSNameURL(String url) {
        return url.contains(TNSNAME_URL_FLAG);
    }

    @Override
    public ConnectionInfo parse(String url) {
        if (this.isTNSNameURL(url)) {
            return this.tnsNameURLParse(url);
        }
        return this.commonsURLParse(url);
    }

    private ConnectionInfo commonsURLParse(String url) {
        String host = this.fetchDatabaseHostsFromURL(url);
        String[] hostSegment = this.splitDatabaseAddress(host);
        String databaseName = this.fetchDatabaseNameFromURL(url);
        if (hostSegment.length == 1) {
            return new ConnectionInfo.Builder(host, 1521).dbType(DB_TYPE).dbInstance(databaseName).build();
        }
        return new ConnectionInfo.Builder(hostSegment[0], Integer.valueOf(hostSegment[1])).dbType(DB_TYPE).dbInstance(databaseName).build();
    }

    private ConnectionInfo tnsNameURLParse(String url) {
        String host = this.parseDatabaseHostsFromURL(url);
        String databaseName = this.fetchDatabaseNameFromURL(url);
        return new ConnectionInfo.Builder(host).dbType(DB_TYPE).dbInstance(databaseName).build();
    }

    private String parseDatabaseHostsFromURL(String url) {
        int hostStartIndex;
        int beginIndex = url.indexOf(TNSNAME_URL_FLAG);
        ArrayList<String> hosts = new ArrayList<String>();
        while ((hostStartIndex = url.indexOf("HOST", beginIndex)) != -1) {
            int equalStartIndex = url.indexOf("=", hostStartIndex);
            int hostEndIndex = url.indexOf(")", hostStartIndex);
            String host = url.substring(equalStartIndex + 1, hostEndIndex);
            int port = 1521;
            int portStartIndex = url.indexOf("PORT", hostEndIndex);
            int portEndIndex = url.length();
            if (portStartIndex != -1) {
                int portEqualStartIndex = url.indexOf("=", portStartIndex);
                portEndIndex = url.indexOf(")", portEqualStartIndex);
                port = Integer.parseInt(url.substring(portEqualStartIndex + 1, portEndIndex).trim());
            }
            hosts.add(host.trim() + ":" + port);
            beginIndex = portEndIndex;
        }
        return this.join(",", hosts);
    }

    private String join(String delimiter, List<String> list) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int len = list.size();
        for (int i = 0; i < len; ++i) {
            if (i == len - 1) {
                builder.append(list.get(i));
                continue;
            }
            builder.append(list.get(i)).append(delimiter);
        }
        return builder.toString();
    }

    private String[] splitDatabaseAddress(String address) {
        String[] hostSegment = address.split(":");
        return hostSegment;
    }
}

