/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jdbc;

import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.contrib.jdbc.ConnectionInfo;
import io.opentracing.noop.NoopSpan;
import io.opentracing.tag.StringTag;
import io.opentracing.tag.Tags;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class JdbcTracingUtils {
    static final String COMPONENT_NAME = "java-jdbc";
    static final StringTag PEER_ADDRESS = new StringTag("peer.address");

    JdbcTracingUtils() {
    }

    static Span buildSpan(String operationName, String sql, ConnectionInfo connectionInfo, boolean withActiveSpanOnly, Set<String> ignoredStatements, Tracer tracer) {
        if (withActiveSpanOnly && tracer.activeSpan() == null) {
            return NoopSpan.INSTANCE;
        }
        if (ignoredStatements != null && ignoredStatements.contains(sql)) {
            return NoopSpan.INSTANCE;
        }
        Tracer.SpanBuilder spanBuilder = tracer.buildSpan(operationName).withTag(Tags.SPAN_KIND.getKey(), "client");
        Span span = spanBuilder.start();
        JdbcTracingUtils.decorate(span, sql, connectionInfo);
        return span;
    }

    private static boolean isNotEmpty(CharSequence s) {
        return s != null && !"".contentEquals(s);
    }

    private static void decorate(Span span, String sql, ConnectionInfo connectionInfo) {
        Tags.COMPONENT.set(span, COMPONENT_NAME);
        if (JdbcTracingUtils.isNotEmpty(sql)) {
            Tags.DB_STATEMENT.set(span, sql);
        }
        if (JdbcTracingUtils.isNotEmpty(connectionInfo.getDbType())) {
            Tags.DB_TYPE.set(span, connectionInfo.getDbType());
        }
        if (JdbcTracingUtils.isNotEmpty(connectionInfo.getDbPeer())) {
            PEER_ADDRESS.set(span, connectionInfo.getDbPeer());
        }
        if (JdbcTracingUtils.isNotEmpty(connectionInfo.getDbInstance())) {
            Tags.DB_INSTANCE.set(span, connectionInfo.getDbInstance());
        }
        if (JdbcTracingUtils.isNotEmpty(connectionInfo.getDbUser())) {
            Tags.DB_USER.set(span, connectionInfo.getDbUser());
        }
        if (JdbcTracingUtils.isNotEmpty(connectionInfo.getPeerService())) {
            Tags.PEER_SERVICE.set(span, connectionInfo.getPeerService());
        }
    }

    static void onError(Throwable throwable, Span span) {
        Tags.ERROR.set(span, Boolean.TRUE);
        if (throwable != null) {
            span.log(JdbcTracingUtils.errorLogs(throwable));
        }
    }

    private static Map<String, Object> errorLogs(Throwable throwable) {
        HashMap<String, Object> errorLogs = new HashMap<String, Object>(3);
        errorLogs.put("event", Tags.ERROR.getKey());
        errorLogs.put("error.object", throwable);
        return errorLogs;
    }
}

