/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jdbc;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.contrib.common.WrapperProxy;
import io.opentracing.contrib.jdbc.ConnectionInfo;
import io.opentracing.contrib.jdbc.JdbcTracingUtils;
import io.opentracing.contrib.jdbc.TracingConnection;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class TracingDataSource
implements DataSource {
    private static final boolean DEFAULT_WITH_ACTIVE_SPAN_ONLY = false;
    private static final Set<String> DEFAULT_IGNORED_STATEMENTS = Collections.emptySet();
    private final Tracer tracer;
    private final DataSource underlying;
    private final ConnectionInfo connectionInfo;
    private final boolean withActiveSpanOnly;
    private final Set<String> ignoreStatements;

    public TracingDataSource(Tracer tracer, DataSource underlying) {
        this(tracer, underlying, ConnectionInfo.UNKNOWN_CONNECTION_INFO, false, DEFAULT_IGNORED_STATEMENTS);
    }

    public TracingDataSource(Tracer tracer, DataSource underlying, ConnectionInfo connectionInfo, boolean withActiveSpanOnly, Set<String> ignoreStatements) {
        this.tracer = tracer;
        this.underlying = underlying;
        this.connectionInfo = connectionInfo;
        this.withActiveSpanOnly = withActiveSpanOnly;
        this.ignoreStatements = ignoreStatements;
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection connection;
        Span span = JdbcTracingUtils.buildSpan("AcquireConnection", "", this.connectionInfo, this.withActiveSpanOnly, this.ignoreStatements, this.tracer);
        try (Scope ignored = this.tracer.activateSpan(span);){
            connection = this.underlying.getConnection();
        }
        catch (Exception e) {
            JdbcTracingUtils.onError(e, span);
            throw e;
        }
        finally {
            span.finish();
        }
        return (Connection)WrapperProxy.wrap((Object)connection, (Object)new TracingConnection(connection, this.connectionInfo, this.withActiveSpanOnly, this.ignoreStatements, this.tracer));
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        Connection connection;
        Span span = JdbcTracingUtils.buildSpan("AcquireConnection", "", this.connectionInfo, this.withActiveSpanOnly, this.ignoreStatements, this.tracer);
        try (Scope ignored = this.tracer.activateSpan(span);){
            connection = this.underlying.getConnection(username, password);
        }
        catch (Exception e) {
            JdbcTracingUtils.onError(e, span);
            throw e;
        }
        finally {
            span.finish();
        }
        return (Connection)WrapperProxy.wrap((Object)connection, (Object)new TracingConnection(connection, this.connectionInfo, this.withActiveSpanOnly, this.ignoreStatements, this.tracer));
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.underlying.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.underlying.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.underlying.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.underlying.getLoginTimeout();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.underlying.getParentLogger();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.underlying.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.underlying.isWrapperFor(iface);
    }
}

