/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jdbc.parser;

import io.opentracing.contrib.jdbc.ConnectionInfo;
import io.opentracing.contrib.jdbc.parser.AbstractURLParser;
import io.opentracing.contrib.jdbc.parser.URLLocation;
import java.net.URI;
import java.net.URISyntaxException;

public class PostgreSQLURLParser
extends AbstractURLParser {
    private static final int DEFAULT_PORT = 5432;
    private static final String DB_TYPE = "postgresql";

    @Override
    protected URLLocation fetchDatabaseHostsIndexRange(String url) {
        int hostLabelStartIndex = url.indexOf("//");
        int hostLabelEndIndex = url.indexOf("/", hostLabelStartIndex + 2);
        return new URLLocation(hostLabelStartIndex + 2, hostLabelEndIndex);
    }

    @Override
    protected URLLocation fetchDatabaseNameIndexRange(String url) {
        int databaseStartTag = url.lastIndexOf("/");
        int databaseEndTag = url.indexOf("?", databaseStartTag);
        if (databaseEndTag == -1) {
            databaseEndTag = url.length();
        }
        return new URLLocation(databaseStartTag + 1, databaseEndTag);
    }

    @Override
    public ConnectionInfo parse(String url) {
        URLLocation location = this.fetchDatabaseHostsIndexRange(url);
        String hosts = url.substring(location.startIndex(), location.endIndex());
        String[] hostSegment = hosts.split(",");
        if (hostSegment.length > 1) {
            StringBuilder sb = new StringBuilder();
            for (String host : hostSegment) {
                URI uri = this.parseHost(host);
                int port = uri.getPort() == -1 ? 5432 : uri.getPort();
                sb.append(uri.getHost() + ":" + port + ",");
            }
            if (',' == sb.charAt(sb.length() - 1)) {
                sb.deleteCharAt(sb.length() - 1);
            }
            return new ConnectionInfo.Builder(sb.toString()).dbType(DB_TYPE).dbInstance(this.fetchDatabaseNameFromURL(url)).build();
        }
        URI uri = this.parseHost(hostSegment[0]);
        int port = uri.getPort() == -1 ? 5432 : uri.getPort();
        return new ConnectionInfo.Builder(uri.getHost(), port).dbType(DB_TYPE).dbInstance(this.fetchDatabaseNameFromURL(url)).build();
    }

    private URI parseHost(String host) {
        try {
            return new URI("proto://" + host);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

