/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jdbc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.Set;

public class DynamicProxy {
    private static void recurse(Class<?> iface, Set<Class<?>> set) {
        if (set.contains(iface)) {
            return;
        }
        set.add(iface);
        for (Class<?> extended : iface.getInterfaces()) {
            DynamicProxy.recurse(extended, set);
        }
    }

    static Class<?>[] getAllInterfaces(Class<?> cls) {
        Class<?> next = cls;
        HashSet ifaces = new HashSet();
        do {
            for (Class<?> iface : next.getInterfaces()) {
                DynamicProxy.recurse(iface, ifaces);
            }
        } while ((next = next.getSuperclass()) != null);
        return ifaces.toArray(new Class[ifaces.size()]);
    }

    public static <T> T wrap(final T target, final T wrapper) {
        Class<?> cls = target.getClass();
        return (T)Proxy.newProxyInstance(cls.getClassLoader(), DynamicProxy.getAllInterfaces(cls), new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                try {
                    return method.invoke(wrapper, args);
                }
                catch (IllegalArgumentException e) {
                    return method.invoke(target, args);
                }
            }
        });
    }
}

