/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jdbc;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.contrib.jdbc.ConnectionInfo;
import io.opentracing.contrib.jdbc.DynamicProxy;
import io.opentracing.contrib.jdbc.JdbcTracingUtils;
import io.opentracing.contrib.jdbc.TracingConnection;
import io.opentracing.contrib.jdbc.parser.URLParser;
import io.opentracing.util.GlobalTracer;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TracingDriver
implements Driver {
    private static final Driver INSTANCE = new TracingDriver();
    protected static final String TRACE_WITH_ACTIVE_SPAN_ONLY = "traceWithActiveSpanOnly";
    protected static final String WITH_ACTIVE_SPAN_ONLY = "traceWithActiveSpanOnly=true";
    public static final String IGNORE_FOR_TRACING_REGEX = "ignoreForTracing=\"((?:\\\\\"|[^\"])*)\"[;]*";
    protected static final Pattern PATTERN_FOR_IGNORING = Pattern.compile("ignoreForTracing=\"((?:\\\\\"|[^\"])*)\"[;]*");
    private static boolean interceptorMode;
    private static boolean withActiveSpanOnly;
    private static Set<String> ignoreStatements;
    protected Tracer tracer;

    public static synchronized Driver load() {
        try {
            Enumeration<Driver> enumeration = DriverManager.getDrivers();
            ArrayList<Driver> drivers = null;
            int i = 0;
            while (enumeration.hasMoreElements()) {
                Driver driver = enumeration.nextElement();
                if (i == 0) {
                    if (driver == INSTANCE) {
                        return driver;
                    }
                    drivers = new ArrayList<Driver>();
                }
                drivers.add(driver);
                ++i;
            }
            if (drivers != null) {
                for (Driver driver : drivers) {
                    DriverManager.deregisterDriver(driver);
                }
            }
            DriverManager.registerDriver(INSTANCE);
            if (drivers != null) {
                for (Driver driver : drivers) {
                    DriverManager.registerDriver(driver);
                }
            }
            return INSTANCE;
        }
        catch (SQLException e) {
            throw new IllegalStateException("Could not register TracingDriver with DriverManager", e);
        }
    }

    public static void setInterceptorMode(boolean interceptorMode) {
        TracingDriver.interceptorMode = interceptorMode;
    }

    public static void setInterceptorProperty(boolean withActiveSpanOnly) {
        TracingDriver.withActiveSpanOnly = withActiveSpanOnly;
    }

    public static void setInterceptorProperty(Set<String> ignoreStatements) {
        TracingDriver.ignoreStatements = ignoreStatements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        Connection connection;
        Set<String> ignoreStatements;
        boolean withActiveSpanOnly;
        if (url == null) {
            throw new SQLException("url is required");
        }
        if (this.acceptsURL(url)) {
            withActiveSpanOnly = url.contains(WITH_ACTIVE_SPAN_ONLY);
            ignoreStatements = this.extractIgnoredStatements(url);
            url = this.extractRealUrl(url);
        } else {
            if (!interceptorMode) {
                return null;
            }
            withActiveSpanOnly = TracingDriver.withActiveSpanOnly;
            ignoreStatements = TracingDriver.ignoreStatements;
        }
        Driver wrappedDriver = this.findDriver(url);
        Tracer currentTracer = this.getTracer();
        ConnectionInfo connectionInfo = URLParser.parser(url);
        Span span = JdbcTracingUtils.buildSpan("AcquireConnection", "", connectionInfo, withActiveSpanOnly, Collections.emptySet(), currentTracer);
        try (Scope ignored = currentTracer.activateSpan(span);){
            connection = wrappedDriver.connect(url, info);
        }
        finally {
            span.finish();
        }
        return DynamicProxy.wrap(connection, new TracingConnection(connection, connectionInfo, withActiveSpanOnly, ignoreStatements, currentTracer));
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return url != null && url.startsWith(this.getUrlPrefix());
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return this.findDriver(url).getPropertyInfo(url, info);
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    public void setTracer(Tracer tracer) {
        this.tracer = tracer;
    }

    protected String getUrlPrefix() {
        return "jdbc:tracing:";
    }

    protected Driver findDriver(String realUrl) throws SQLException {
        if (realUrl == null || realUrl.trim().length() == 0) {
            throw new IllegalArgumentException("url is required");
        }
        for (Driver candidate : Collections.list(DriverManager.getDrivers())) {
            try {
                if (candidate instanceof TracingDriver || !candidate.acceptsURL(realUrl)) continue;
                return candidate;
            }
            catch (SQLException sQLException) {
            }
        }
        throw new SQLException("Unable to find a driver that accepts url: " + realUrl);
    }

    protected String extractRealUrl(String url) {
        String extracted = url.startsWith(this.getUrlPrefix()) ? url.replace(this.getUrlPrefix(), "jdbc:") : url;
        return extracted.replaceAll("traceWithActiveSpanOnly=(true|false)[;]*", "").replaceAll(IGNORE_FOR_TRACING_REGEX, "").replaceAll("\\?$", "");
    }

    protected Set<String> extractIgnoredStatements(String url) {
        Matcher matcher = PATTERN_FOR_IGNORING.matcher(url);
        HashSet<String> results = new HashSet<String>(8);
        while (matcher.find()) {
            String rawValue = matcher.group(1);
            String finalValue = rawValue.replace("\\\"", "\"");
            results.add(finalValue);
        }
        return results;
    }

    Tracer getTracer() {
        if (this.tracer == null) {
            return GlobalTracer.get();
        }
        return this.tracer;
    }

    static {
        TracingDriver.load();
        interceptorMode = false;
    }
}

