/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jms.common;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.contrib.jms.common.TracingMessageUtils;
import io.opentracing.util.GlobalTracer;
import javax.jms.Message;
import javax.jms.MessageListener;

public class TracingMessageListener
implements MessageListener {
    private final MessageListener messageListener;
    private final Tracer tracer;

    public TracingMessageListener(MessageListener messageListener) {
        this(messageListener, GlobalTracer.get());
    }

    public TracingMessageListener(MessageListener messageListener, Tracer tracer) {
        this.messageListener = messageListener;
        this.tracer = tracer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        Span span = TracingMessageUtils.buildFollowingSpan(message, this.tracer);
        try (Scope ignored = this.tracer.activateSpan(span);){
            if (this.messageListener != null) {
                this.messageListener.onMessage(message);
            }
        }
        finally {
            span.finish();
        }
    }
}

