/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jms.common;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.contrib.jms.common.JmsTextMapExtractAdapter;
import io.opentracing.contrib.jms.common.JmsTextMapInjectAdapter;
import io.opentracing.contrib.jms.common.SpanJmsDecorator;
import io.opentracing.noop.NoopSpan;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;
import javax.jms.Destination;
import javax.jms.Message;

public class TracingMessageUtils {
    public static final String OPERATION_NAME_SEND = "jms-send";
    public static final String OPERATION_NAME_RECEIVE = "jms-receive";
    public static final String COMPONENT_NAME = "java-jms";

    public static Span buildAndFinishChildSpan(Message message, Tracer tracer) {
        Span child = TracingMessageUtils.buildFollowingSpan(message, tracer);
        if (child != null) {
            child.finish();
        }
        return child;
    }

    public static Span buildFollowingSpan(Message message, Tracer tracer) {
        SpanContext context = TracingMessageUtils.extract(message, tracer);
        if (context != null) {
            Tracer.SpanBuilder spanBuilder = tracer.buildSpan(OPERATION_NAME_RECEIVE).ignoreActiveSpan().withTag(Tags.SPAN_KIND.getKey(), "consumer");
            spanBuilder.addReference("follows_from", context);
            Span span = spanBuilder.start();
            SpanJmsDecorator.onResponse(message, span);
            return span;
        }
        return NoopSpan.INSTANCE;
    }

    public static SpanContext extract(Message message, Tracer tracer) {
        SpanContext spanContext = tracer.extract(Format.Builtin.TEXT_MAP, (Object)new JmsTextMapExtractAdapter(message));
        if (spanContext != null) {
            return spanContext;
        }
        Span span = tracer.activeSpan();
        if (span != null) {
            return span.context();
        }
        return null;
    }

    public static void inject(Span span, Message message, Tracer tracer) {
        tracer.inject(span.context(), Format.Builtin.TEXT_MAP, (Object)new JmsTextMapInjectAdapter(message));
    }

    public static Span buildAndInjectSpan(Destination destination, Message message, Tracer tracer) {
        Tracer.SpanBuilder spanBuilder = tracer.buildSpan(OPERATION_NAME_SEND).ignoreActiveSpan().withTag(Tags.SPAN_KIND.getKey(), "producer");
        SpanContext parent = TracingMessageUtils.extract(message, tracer);
        if (parent != null) {
            spanBuilder.asChildOf(parent);
        }
        Span span = spanBuilder.start();
        SpanJmsDecorator.onRequest(destination, span);
        TracingMessageUtils.inject(span, message, tracer);
        return span;
    }
}

