/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jms.spring;

import io.opentracing.contrib.jms.spring.TracingMessagingMessageListenerAdapter;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.jms.config.JmsListenerContainerFactory;
import org.springframework.jms.config.JmsListenerEndpoint;
import org.springframework.jms.config.JmsListenerEndpointRegistrar;
import org.springframework.jms.config.JmsListenerEndpointRegistry;
import org.springframework.jms.config.MethodJmsListenerEndpoint;
import org.springframework.jms.listener.adapter.MessagingMessageListenerAdapter;
import org.springframework.messaging.handler.annotation.support.DefaultMessageHandlerMethodFactory;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;

public class TracingJmsListenerEndpointRegistry
extends JmsListenerEndpointRegistry
implements BeanFactoryAware {
    private TracingMessagingMessageListenerAdapter listenerAdapter;
    private BeanFactory beanFactory;
    private JmsListenerEndpointRegistrar registrar;

    public TracingJmsListenerEndpointRegistry(TracingMessagingMessageListenerAdapter listenerAdapter) {
        this.listenerAdapter = listenerAdapter;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    void setRegistrar(JmsListenerEndpointRegistrar registrar) {
        this.registrar = registrar;
    }

    public void registerListenerContainer(JmsListenerEndpoint endpoint, JmsListenerContainerFactory<?> factory, boolean startImmediately) {
        if (endpoint instanceof MethodJmsListenerEndpoint) {
            endpoint = this.replaceMethodJmsListenerEndpoint((MethodJmsListenerEndpoint)endpoint);
        }
        super.registerListenerContainer(endpoint, factory, startImmediately);
    }

    private JmsListenerEndpoint replaceMethodJmsListenerEndpoint(MethodJmsListenerEndpoint original) {
        TracingMethodJmsListenerEndpoint replacement = new TracingMethodJmsListenerEndpoint();
        replacement.setBean(original.getBean());
        replacement.setMethod(original.getMethod());
        replacement.setMostSpecificMethod(original.getMostSpecificMethod());
        MessageHandlerMethodFactory messageHandlerMethodFactory = this.registrar.getMessageHandlerMethodFactory();
        if (messageHandlerMethodFactory == null) {
            messageHandlerMethodFactory = this.createDefaultJmsHandlerMethodFactory();
        }
        replacement.setMessageHandlerMethodFactory(messageHandlerMethodFactory);
        replacement.setBeanFactory(this.beanFactory);
        replacement.setId(original.getId());
        replacement.setDestination(original.getDestination());
        replacement.setSelector(original.getSelector());
        replacement.setSubscription(original.getSubscription());
        replacement.setConcurrency(original.getConcurrency());
        return replacement;
    }

    private MessageHandlerMethodFactory createDefaultJmsHandlerMethodFactory() {
        DefaultMessageHandlerMethodFactory defaultFactory = new DefaultMessageHandlerMethodFactory();
        defaultFactory.setBeanFactory(this.beanFactory);
        defaultFactory.afterPropertiesSet();
        return defaultFactory;
    }

    private class TracingMethodJmsListenerEndpoint
    extends MethodJmsListenerEndpoint {
        private TracingMethodJmsListenerEndpoint() {
        }

        protected MessagingMessageListenerAdapter createMessageListenerInstance() {
            return TracingJmsListenerEndpointRegistry.this.listenerAdapter.newInstance();
        }
    }
}

