/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jms.spring;

import io.opentracing.Tracer;
import io.opentracing.contrib.jms2.TracingConnection;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import org.springframework.jms.core.JmsTemplate;

public class TracingJmsTemplate
extends JmsTemplate {
    private final Tracer tracer;
    private final boolean traceInLog;

    public TracingJmsTemplate(Tracer tracer) {
        this(tracer, false);
    }

    public TracingJmsTemplate(Tracer tracer, boolean traceInLog) {
        this.tracer = tracer;
        this.traceInLog = traceInLog;
    }

    public TracingJmsTemplate(ConnectionFactory connectionFactory, Tracer tracer, boolean traceInLog) {
        super(connectionFactory);
        this.tracer = tracer;
        this.traceInLog = traceInLog;
    }

    protected Connection createConnection() throws JMSException {
        return new TracingConnection(super.createConnection(), this.tracer, this.traceInLog);
    }
}

