/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jms.spring;

import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.contrib.jms.common.TracingMessageListener;
import io.opentracing.contrib.jms.common.TracingMessageUtils;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Session;
import org.springframework.jms.listener.adapter.MessagingMessageListenerAdapter;

public class TracingMessagingMessageListenerAdapter
extends MessagingMessageListenerAdapter {
    protected Tracer tracer;
    protected boolean traceInLog;

    protected TracingMessagingMessageListenerAdapter(Tracer tracer) {
        this(tracer, false);
    }

    protected TracingMessagingMessageListenerAdapter(Tracer tracer, boolean traceInLog) {
        this.tracer = tracer;
        this.traceInLog = traceInLog;
    }

    public void onMessage(Message jmsMessage, final Session session) throws JMSException {
        TracingMessageListener listener = new TracingMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                TracingMessagingMessageListenerAdapter.this.onMessageInternal(message, session);
            }
        }, this.tracer, this.traceInLog);
        listener.onMessage(jmsMessage);
    }

    private void onMessageInternal(Message jmsMessage, Session session) {
        try {
            super.onMessage(jmsMessage, session);
        }
        catch (JMSException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendResponse(Session session, Destination destination, Message response) throws JMSException {
        Span span = TracingMessageUtils.buildAndInjectSpan((Destination)destination, (Message)response, (Tracer)this.tracer);
        try {
            super.sendResponse(session, destination, response);
        }
        finally {
            span.finish();
        }
    }

    protected TracingMessagingMessageListenerAdapter newInstance() {
        return new TracingMessagingMessageListenerAdapter(this.tracer, this.traceInLog);
    }
}

